/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import org.apache.metamodel.neo4j.Neo4jDataContext;
import org.datacleaner.connection.DatastoreConnectionImpl;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;

public class Neo4jDatastore
extends UsageAwareDatastore<Neo4jDataContext> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_PORT = 7474;
    private final String _hostname;
    private final int _port;
    private final String _username;
    private final String _password;

    public Neo4jDatastore(String name, String hostname, String username, String password) {
        this(name, hostname, 7474, username, password);
    }

    public Neo4jDatastore(String name, String hostname, int port, String username, String password) {
        super(name);
        this._hostname = hostname;
        this._port = port;
        this._username = username;
        this._password = password;
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(false, true);
    }

    @Override
    protected UsageAwareDatastoreConnection<Neo4jDataContext> createDatastoreConnection() {
        if (this._hostname != null & this._username != null & this._password != null) {
            Neo4jDataContext dataContext = new Neo4jDataContext(this._hostname, this._port, this._username, this._password);
            return new DatastoreConnectionImpl<Neo4jDataContext>(dataContext, this, new AutoCloseable[0]);
        }
        return null;
    }

    public String getHostname() {
        return this._hostname;
    }

    public String getUsername() {
        return this._username;
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        return this._port;
    }

    @Override
    public String toString() {
        return "Neo4jDatastore[name=" + this.getName() + ", hostname=" + this._hostname + ", port=" + this._port + ", _username=" + this._username + "]";
    }
}

