/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.connection;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.DataContextFactory;
import org.datacleaner.connection.DatastoreConnectionImpl;
import org.datacleaner.connection.FileDatastore;
import org.datacleaner.connection.PerformanceCharacteristics;
import org.datacleaner.connection.PerformanceCharacteristicsImpl;
import org.datacleaner.connection.UsageAwareDatastore;
import org.datacleaner.connection.UsageAwareDatastoreConnection;
import org.datacleaner.util.ReadObjectBuilder;

public final class OdbDatastore
extends UsageAwareDatastore<DataContext>
implements FileDatastore {
    private static final long serialVersionUID = 1L;
    private final String _filename;

    public OdbDatastore(String name, String filename) {
        super(name);
        this._filename = filename;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ReadObjectBuilder.create(this, OdbDatastore.class).readObject(stream);
    }

    @Override
    public String getFilename() {
        return this._filename;
    }

    @Override
    protected UsageAwareDatastoreConnection<DataContext> createDatastoreConnection() {
        DataContext dc = DataContextFactory.createOpenOfficeDataContext((File)new File(this._filename));
        return new DatastoreConnectionImpl<DataContext>(dc, this, new AutoCloseable[0]);
    }

    public PerformanceCharacteristics getPerformanceCharacteristics() {
        return new PerformanceCharacteristicsImpl(true, false);
    }

    @Override
    protected void decorateIdentity(List<Object> identifiers) {
        super.decorateIdentity(identifiers);
        identifiers.add(this._filename);
    }
}

