/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.lang.reflect.Field;
import java.util.Collection;
import org.datacleaner.data.AbstractInputRow;

abstract class AbstractLegacyAwareInputRow
extends AbstractInputRow {
    private static final long serialVersionUID = 1L;

    AbstractLegacyAwareInputRow() {
    }

    protected abstract String getFieldNameForOldId();

    protected abstract String getFieldNameForNewId();

    protected abstract Collection<String> getFieldNamesInAdditionToId();

    protected void doReadObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField readFields = stream.readFields();
        for (String fieldName : this.getFieldNamesInAdditionToId()) {
            Object value = readFields.get(fieldName, null);
            this.setField(fieldName, value);
        }
        ObjectStreamField legacyRowNumberField = readFields.getObjectStreamClass().getField(this.getFieldNameForOldId());
        long rowNumber = legacyRowNumberField != null ? (long)readFields.get(this.getFieldNameForOldId(), -1) : readFields.get(this.getFieldNameForNewId(), -1L);
        this.setField(this.getFieldNameForNewId(), rowNumber);
    }

    private void setField(String fieldName, Object value) {
        try {
            Field field = this.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(this, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to set field '" + fieldName + "' to value: " + value, e);
        }
    }
}

