/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.AbstractLegacyAwareInputRow;
import org.datacleaner.data.MetaModelInputColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetaModelInputRow
extends AbstractLegacyAwareInputRow {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MetaModelInputRow.class);
    private final Row _row;
    private final long _id;

    public MetaModelInputRow(long rowNumber, Row row) {
        this._id = rowNumber;
        this._row = row;
    }

    @Override
    protected String getFieldNameForNewId() {
        return "_id";
    }

    @Override
    protected String getFieldNameForOldId() {
        return "_rowNumber";
    }

    @Override
    protected Collection<String> getFieldNamesInAdditionToId() {
        return Arrays.asList("_row");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.doReadObject(stream);
    }

    public long getId() {
        return this._id;
    }

    public Row getRow() {
        return this._row;
    }

    public boolean containsInputColumn(InputColumn<?> inputColumn) {
        SelectItem[] selectItems;
        if (!inputColumn.isPhysicalColumn()) {
            return false;
        }
        Column physicalColumn = inputColumn.getPhysicalColumn();
        for (SelectItem selectItem : selectItems = this._row.getSelectItems()) {
            Column column;
            if (selectItem.getColumn() == null || selectItem.getAggregateFunction() != null || !physicalColumn.equals(column = selectItem.getColumn())) continue;
            return true;
        }
        return false;
    }

    @Override
    public <E> E getValueInternal(InputColumn<E> column) {
        if (!column.isPhysicalColumn()) {
            return null;
        }
        Column physicalColumn = column.getPhysicalColumn();
        Object value = this._row.getValue(physicalColumn);
        value = this.convertValue(value);
        return (E)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object convertValue(Object value) {
        if (value instanceof Clob) {
            try {
                Reader reader = ((Clob)value).getCharacterStream();
                try {
                    value = FileHelper.readAsString((Reader)reader);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{reader});
                    throw throwable;
                }
                FileHelper.safeClose((Object[])new Object[]{reader});
            }
            catch (SQLException e) {
                logger.error("Failed to convert CLOB to String", (Throwable)e);
                value = null;
            }
        } else if (value instanceof Blob) {
            try {
                InputStream inputStream = ((Blob)value).getBinaryStream();
                try {
                    value = FileHelper.readAsBytes((InputStream)inputStream);
                }
                catch (Throwable throwable) {
                    FileHelper.safeClose((Object[])new Object[]{inputStream});
                    throw throwable;
                }
                FileHelper.safeClose((Object[])new Object[]{inputStream});
            }
            catch (SQLException e) {
                logger.error("Failed to convert BLOB to byte[]", (Throwable)e);
                value = null;
            }
        }
        return value;
    }

    public String toString() {
        return "MetaModelInputRow[" + this._row + "]";
    }

    public List<InputColumn<?>> getInputColumns() {
        SelectItem[] selectItems;
        ArrayList result = new ArrayList();
        for (SelectItem selectItem : selectItems = this._row.getSelectItems()) {
            if (selectItem.getColumn() == null || selectItem.getAggregateFunction() != null) continue;
            result.add(new MetaModelInputColumn(selectItem.getColumn()));
        }
        return result;
    }
}

