/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.AbstractLegacyAwareInputRow;

public class MockInputRow
extends AbstractLegacyAwareInputRow {
    private static final long serialVersionUID = 1L;
    private static final AtomicInteger _idGenerator = new AtomicInteger(Integer.MIN_VALUE);
    private final Map<InputColumn<?>, Object> _values;
    private final long _rowId;

    public MockInputRow() {
        this(_idGenerator.getAndIncrement());
    }

    public MockInputRow(long id, Map<InputColumn<?>, Object> values) {
        this._values = values;
        this._rowId = id;
    }

    public MockInputRow(Map<InputColumn<?>, Object> values) {
        this(_idGenerator.getAndIncrement(), values);
    }

    public MockInputRow(long id) {
        this(id, new LinkedHashMap());
    }

    public MockInputRow(InputColumn<?>[] columns, Object[] values) {
        this(_idGenerator.getAndIncrement(), columns, values);
    }

    public MockInputRow(int id, InputColumn<?>[] columns, Object[] values) {
        this(id);
        for (int i = 0; i < values.length; ++i) {
            this.put(columns[i], values[i]);
        }
    }

    @Override
    protected String getFieldNameForNewId() {
        return "_rowId";
    }

    @Override
    protected String getFieldNameForOldId() {
        return "_id";
    }

    @Override
    protected Collection<String> getFieldNamesInAdditionToId() {
        return Arrays.asList("_values");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.doReadObject(stream);
    }

    public long getId() {
        return this._rowId;
    }

    public List<InputColumn<?>> getInputColumns() {
        return new ArrayList(this._values.keySet());
    }

    public boolean containsInputColumn(InputColumn<?> inputColumn) {
        return this._values.containsKey(inputColumn);
    }

    @Override
    public <E> E getValueInternal(InputColumn<E> column) {
        return (E)this._values.get(column);
    }

    public MockInputRow put(InputColumn<?> column, Object value) {
        this._values.put(column, value);
        return this;
    }

    public MockInputRow putAll(Map<InputColumn<?>, Object> values) {
        this._values.putAll(values);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this._rowId, this._values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MockInputRow other = (MockInputRow)obj;
        if (this._rowId != other._rowId) {
            return false;
        }
        return !(this._values == null ? other._values != null : !this._values.equals(other._values));
    }

    public String toString() {
        return "MockInputRow[id=" + this._rowId + "]";
    }
}

