/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.metamodel.schema.Column;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.job.IdGenerator;
import org.datacleaner.util.InputColumnComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformedInputColumn<E>
implements MutableInputColumn<E>,
Serializable,
Comparable<InputColumn<E>> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TransformedInputColumn.class);
    private final transient Collection<MutableInputColumn.Listener> _listeners;
    private final String _id;
    private Class<?> _dataType;
    private String _name;
    private String _initialName;
    private boolean _hidden;

    public TransformedInputColumn(String name, IdGenerator idGenerator) {
        this(name, idGenerator.nextId());
    }

    public TransformedInputColumn(String name, String id) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        this._name = name;
        this._initialName = name;
        this._id = id;
        this._listeners = new HashSet<MutableInputColumn.Listener>();
        this._hidden = false;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public String getInitialName() {
        return this._initialName;
    }

    public void setInitialName(String initialName) {
        this._initialName = initialName;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.equals(this._name)) {
            return;
        }
        String oldName = this._name;
        this._name = name;
        for (MutableInputColumn.Listener listener : this.getListeners()) {
            listener.onNameChanged(this, oldName, name);
        }
    }

    public Collection<MutableInputColumn.Listener> getListeners() {
        if (this._listeners == null) {
            return Collections.emptyList();
        }
        return this._listeners;
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setDataType(Class<?> dataType) {
        this._dataType = dataType;
    }

    public boolean isPhysicalColumn() {
        return false;
    }

    public boolean isVirtualColumn() {
        return true;
    }

    public String toString() {
        return "TransformedInputColumn[id=" + this._id + ",name=" + this._name + "]";
    }

    public Column getPhysicalColumn() throws IllegalStateException {
        return null;
    }

    public Class<? extends E> getDataType() {
        return this._dataType;
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(InputColumn<E> o) {
        return InputColumnComparator.compareInputColumns(this, o);
    }

    @Override
    public boolean isHidden() {
        return this._hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this._hidden = hidden;
        for (MutableInputColumn.Listener listener : this.getListeners()) {
            listener.onVisibilityChanged(this, hidden);
        }
    }

    @Override
    public boolean addListener(MutableInputColumn.Listener listener) {
        if (this._listeners == null) {
            logger.warn("Attempted to add listener onto TransformedInputColumn with null List of listeners");
            return false;
        }
        boolean added = this._listeners.add(listener);
        if (logger.isDebugEnabled()) {
            logger.debug("[{}].addListener({}): {}", new Object[]{this.getName(), listener, added});
        }
        return added;
    }

    @Override
    public boolean removeListener(MutableInputColumn.Listener listener) {
        if (this._listeners == null) {
            logger.warn("Attempted to remove listener onto TransformedInputColumn with null List of listeners");
            return false;
        }
        boolean removed = this._listeners.remove(listener);
        if (logger.isDebugEnabled()) {
            logger.debug("[{}].removeListener({}): {}", new Object[]{this.getName(), listener, removed});
            logger.debug("[{}].listeners.size: {}", (Object)this.getName(), (Object)this._listeners.size());
        }
        return removed;
    }
}

