/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.data.AbstractLegacyAwareInputRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformedInputRow
extends AbstractLegacyAwareInputRow {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TransformedInputRow.class);
    private final InputRow _delegate;
    private final Map<InputColumn<?>, Object> _values;
    private final long _id;

    public static TransformedInputRow of(InputRow row) {
        if (row instanceof TransformedInputRow) {
            return (TransformedInputRow)row;
        }
        return new TransformedInputRow(row, row.getId());
    }

    @Deprecated
    public TransformedInputRow(InputRow delegate) {
        this(delegate, null);
    }

    public TransformedInputRow(InputRow delegate, Number rowId) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate cannot be null");
        }
        this._delegate = delegate;
        this._id = rowId == null ? delegate.getId() : rowId.longValue();
        this._values = new LinkedHashMap();
    }

    public TransformedInputRow(InputRow delegate, long rowId) {
        if (delegate == null) {
            throw new IllegalArgumentException("Delegate cannot be null");
        }
        this._delegate = delegate;
        this._id = rowId;
        this._values = new LinkedHashMap();
    }

    @Override
    protected String getFieldNameForNewId() {
        return "_id";
    }

    @Override
    protected String getFieldNameForOldId() {
        return "_rowId";
    }

    @Override
    protected Collection<String> getFieldNamesInAdditionToId() {
        return Arrays.asList("_delegate", "_values");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.doReadObject(stream);
    }

    public long getId() {
        return this._id;
    }

    public boolean containsInputColumn(InputColumn<?> inputColumn) {
        if (inputColumn.isVirtualColumn() && this._values.containsKey(inputColumn)) {
            return true;
        }
        return this._delegate.containsInputColumn(inputColumn);
    }

    public void addValue(InputColumn<?> inputColumn, Object value) {
        if (inputColumn.isPhysicalColumn()) {
            throw new IllegalArgumentException("Cannot add physical column values to transformed InputRow.");
        }
        this._values.put(inputColumn, value);
    }

    @Override
    public <E> E getValueInternal(InputColumn<E> column) {
        if (column.isPhysicalColumn()) {
            logger.debug("Column is physical, delegating.");
            return (E)this._delegate.getValue(column);
        }
        if (this._values.containsKey(column)) {
            return (E)this._values.get(column);
        }
        return (E)this._delegate.getValue(column);
    }

    public InputRow getDelegate() {
        return this._delegate;
    }

    public List<InputColumn<?>> getInputColumns() {
        List inputColumns = this._delegate.getInputColumns();
        inputColumns.addAll(this._values.keySet());
        return inputColumns;
    }

    public Set<InputColumn<?>> getTransformedInputColumns() {
        return this._values.keySet();
    }

    public String toString() {
        return "TransformedInputRow[values=" + this._values + ",delegate=" + this._delegate + "]";
    }
}

