/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.datacleaner.descriptors.DescriptorException;
import org.datacleaner.util.ReflectionUtils;

public abstract class AbstractDescriptor<B>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<B> _componentClass;

    public AbstractDescriptor(Class<B> componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException("Component class cannot be null");
        }
        if (componentClass.isInterface() || Modifier.isAbstract(componentClass.getModifiers())) {
            throw new DescriptorException("Component (" + componentClass + ") is not a non-abstract class");
        }
        this._componentClass = componentClass;
    }

    protected void visitClass() {
        Method[] methods;
        Field[] fields;
        for (Field field : fields = ReflectionUtils.getAllFields(this._componentClass)) {
            this.visitField(field);
        }
        for (Method method : methods = ReflectionUtils.getMethods(this._componentClass)) {
            this.visitMethod(method);
        }
    }

    protected abstract void visitField(Field var1);

    protected abstract void visitMethod(Method var1);

    public Class<B> getComponentClass() {
        return this._componentClass;
    }

    public int hashCode() {
        return this._componentClass.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            AbstractDescriptor that = (AbstractDescriptor)obj;
            return this._componentClass == that._componentClass;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._componentClass.getName() + "]";
    }
}

