/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.api.Filter;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RenderingFormat;
import org.datacleaner.api.Transformer;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.DescriptorProviderListener;
import org.datacleaner.descriptors.Descriptors;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.descriptors.RendererBeanDescriptor;
import org.datacleaner.descriptors.TransformerDescriptor;

public abstract class AbstractDescriptorProvider
implements DescriptorProvider {
    private final boolean _autoDiscover;
    private final Collection<DescriptorProviderListener> _listeners;

    public AbstractDescriptorProvider(boolean autoLoadDescriptorClasses) {
        this._autoDiscover = autoLoadDescriptorClasses;
        this._listeners = new ArrayList<DescriptorProviderListener>();
    }

    public final AnalyzerDescriptor<?> getAnalyzerDescriptorByDisplayName(String name) {
        return (AnalyzerDescriptor)this.getComponentDescriptorByDisplayName(name, this.getAnalyzerDescriptors(), true, true);
    }

    public ComponentDescriptor<?> getComponentDescriptorByDisplayName(String name) {
        Iterable allComponentDescriptors = Iterables.concat((Iterable)this.getAnalyzerDescriptors(), (Iterable)this.getTransformerDescriptors(), (Iterable)this.getFilterDescriptors());
        Object match = this.getComponentDescriptorByDisplayName(name, allComponentDescriptors, true, false);
        if (match == null) {
            match = this.getComponentDescriptorByDisplayName(name, allComponentDescriptors, false, true);
        }
        return match;
    }

    public final <A extends Analyzer<?>> AnalyzerDescriptor<A> getAnalyzerDescriptorForClass(Class<A> analyzerBeanClass) {
        for (AnalyzerDescriptor descriptor : this.getAnalyzerDescriptors()) {
            if (descriptor.getComponentClass() != analyzerBeanClass) continue;
            return descriptor;
        }
        return this.notFoundAnalyzer(analyzerBeanClass);
    }

    public final FilterDescriptor<?, ?> getFilterDescriptorByDisplayName(String name) {
        return (FilterDescriptor)this.getComponentDescriptorByDisplayName(name, this.getFilterDescriptors(), true, true);
    }

    public final <F extends Filter<C>, C extends Enum<C>> FilterDescriptor<F, C> getFilterDescriptorForClass(Class<F> filterClass) {
        return this.getFilterBeanDescriptorForClassUnbounded(filterClass);
    }

    protected final FilterDescriptor<?, ?> getFilterBeanDescriptorForClassUnbounded(Class<?> filterClass) {
        for (FilterDescriptor descriptor : this.getFilterDescriptors()) {
            if (filterClass != descriptor.getComponentClass()) continue;
            return descriptor;
        }
        return this.notFoundFilter(filterClass);
    }

    public final <R extends Renderer<?, ?>> RendererBeanDescriptor<R> getRendererBeanDescriptorForClass(Class<R> rendererBeanClass) {
        for (RendererBeanDescriptor descriptor : this.getRendererBeanDescriptors()) {
            if (descriptor.getComponentClass() != rendererBeanClass) continue;
            RendererBeanDescriptor result = descriptor;
            return result;
        }
        return this.notFoundRenderer(rendererBeanClass);
    }

    public final TransformerDescriptor<?> getTransformerDescriptorByDisplayName(String name) {
        return (TransformerDescriptor)this.getComponentDescriptorByDisplayName(name, this.getTransformerDescriptors(), true, true);
    }

    public final <T extends Transformer> TransformerDescriptor<T> getTransformerDescriptorForClass(Class<T> transformerClass) {
        for (TransformerDescriptor descriptor : this.getTransformerDescriptors()) {
            if (descriptor.getComponentClass() != transformerClass) continue;
            return descriptor;
        }
        return this.notFoundTransformer(transformerClass);
    }

    public final Collection<RendererBeanDescriptor<?>> getRendererBeanDescriptorsForRenderingFormat(Class<? extends RenderingFormat<?>> renderingFormat) {
        ArrayList result = new ArrayList();
        Collection descriptors = this.getRendererBeanDescriptors();
        for (RendererBeanDescriptor descriptor : descriptors) {
            Class descriptorsRenderingFormat = descriptor.getRenderingFormat();
            if (descriptorsRenderingFormat != renderingFormat) continue;
            result.add(descriptor);
        }
        return result;
    }

    private <D extends ComponentDescriptor<?>> D getComponentDescriptorByDisplayName(String name, Iterable<D> descriptors, boolean searchPrimaryNames, boolean searchAliases) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        if (searchPrimaryNames) {
            for (ComponentDescriptor descriptor : descriptors) {
                String displayName = descriptor.getDisplayName();
                if (!name.equals(displayName)) continue;
                return (D)descriptor;
            }
        }
        if (searchAliases) {
            for (ComponentDescriptor descriptor : descriptors) {
                Object[] aliases = descriptor.getAliases();
                if (!ArrayUtils.contains((Object[])aliases, (Object)name)) continue;
                return (D)descriptor;
            }
        }
        return null;
    }

    private <A extends Analyzer<?>> AnalyzerDescriptor<A> notFoundAnalyzer(Class<A> analyzerClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofAnalyzer(analyzerClass);
    }

    private FilterDescriptor<?, ?> notFoundFilter(Class<?> filterClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofFilterUnbound(filterClass);
    }

    private <R extends Renderer<?, ?>> RendererBeanDescriptor<R> notFoundRenderer(Class<R> rendererClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofRenderer(rendererClass);
    }

    private <T extends Transformer> TransformerDescriptor<T> notFoundTransformer(Class<T> transformerClass) {
        if (!this._autoDiscover) {
            return null;
        }
        return Descriptors.ofTransformer(transformerClass);
    }

    public Collection<? extends ComponentDescriptor<?>> getComponentDescriptors() {
        ArrayList result = new ArrayList();
        result.addAll(this.getTransformerDescriptors());
        result.addAll(this.getFilterDescriptors());
        result.addAll(this.getAnalyzerDescriptors());
        return result;
    }

    public Set<ComponentSuperCategory> getComponentSuperCategories() {
        TreeSet<ComponentSuperCategory> result = new TreeSet<ComponentSuperCategory>();
        Collection<ComponentDescriptor<?>> descriptors = this.getComponentDescriptors();
        for (ComponentDescriptor<?> componentDescriptor : descriptors) {
            ComponentSuperCategory superCategory = componentDescriptor.getComponentSuperCategory();
            result.add(superCategory);
        }
        return result;
    }

    public Collection<? extends ComponentDescriptor<?>> getComponentDescriptorsOfSuperCategory(ComponentSuperCategory category) {
        if (category == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        Collection<ComponentDescriptor<?>> descriptors = this.getComponentDescriptors();
        for (ComponentDescriptor<?> componentDescriptor : descriptors) {
            if (!category.equals(componentDescriptor.getComponentSuperCategory())) continue;
            result.add(componentDescriptor);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        Collection<DescriptorProviderListener> collection = this._listeners;
        synchronized (collection) {
            for (DescriptorProviderListener listener : this._listeners) {
                listener.onDescriptorsUpdated((DescriptorProvider)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DescriptorProviderListener listener) {
        Collection<DescriptorProviderListener> collection = this._listeners;
        synchronized (collection) {
            this._listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(DescriptorProviderListener listener) {
        Collection<DescriptorProviderListener> collection = this._listeners;
        synchronized (collection) {
            this._listeners.remove(listener);
        }
    }
}

