/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import org.datacleaner.api.Analyzer;
import org.datacleaner.api.AnalyzerResultReducer;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.api.Distributed;
import org.datacleaner.api.NoAnalyzerResultReducer;
import org.datacleaner.components.categories.AnalyzeSuperCategory;
import org.datacleaner.descriptors.AbstractHasAnalyzerResultComponentDescriptor;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.DescriptorException;
import org.datacleaner.util.ReflectionUtils;
import org.eobjects.analyzer.beans.api.AnalyzerBean;

final class AnnotationBasedAnalyzerComponentDescriptor<A extends Analyzer<?>>
extends AbstractHasAnalyzerResultComponentDescriptor<A>
implements AnalyzerDescriptor<A> {
    private static final long serialVersionUID = 1L;

    protected AnnotationBasedAnalyzerComponentDescriptor(Class<A> analyzerClass) throws DescriptorException {
        super(analyzerClass, true);
        if (!ReflectionUtils.is(analyzerClass, Analyzer.class)) {
            throw new DescriptorException(analyzerClass + " does not implement " + Analyzer.class.getName());
        }
        this.visitClass();
    }

    @Override
    protected String getDisplayNameIfNotNamed(Class<?> cls) {
        AnalyzerBean annotation = ReflectionUtils.getAnnotation(cls, AnalyzerBean.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    @Override
    protected Class<? extends ComponentSuperCategory> getDefaultComponentSuperCategoryClass() {
        return AnalyzeSuperCategory.class;
    }

    @Override
    public Class<? extends AnalyzerResultReducer<?>> getResultReducerClass() {
        Distributed distributedAnalyzer = this.getAnnotation(Distributed.class);
        if (distributedAnalyzer != null) {
            if (!distributedAnalyzer.value()) {
                return super.getResultReducerClass();
            }
            Class reducer = distributedAnalyzer.reducer();
            if (reducer != null && reducer != NoAnalyzerResultReducer.class) {
                return reducer;
            }
        }
        return super.getResultReducerClass();
    }

    @Override
    protected boolean isDistributableByDefault() {
        return this.getResultReducerClass() != null;
    }
}

