/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.api.Transformer;
import org.datacleaner.components.categories.TransformSuperCategory;
import org.datacleaner.descriptors.AbstractComponentDescriptor;
import org.datacleaner.descriptors.DescriptorException;
import org.datacleaner.descriptors.TransformerDescriptor;
import org.datacleaner.util.ReflectionUtils;
import org.eobjects.analyzer.beans.api.TransformerBean;

final class AnnotationBasedTransformerComponentDescriptor<T extends Transformer>
extends AbstractComponentDescriptor<T>
implements TransformerDescriptor<T> {
    private static final long serialVersionUID = 1L;

    protected AnnotationBasedTransformerComponentDescriptor(Class<T> transformerClass) throws DescriptorException {
        super(transformerClass, false);
        if (!ReflectionUtils.is(transformerClass, Transformer.class)) {
            throw new DescriptorException(transformerClass + " does not implement " + Transformer.class.getName());
        }
        this.visitClass();
    }

    @Override
    protected String getDisplayNameIfNotNamed(Class<?> cls) {
        TransformerBean annotation = ReflectionUtils.getAnnotation(cls, TransformerBean.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    @Override
    protected Class<? extends ComponentSuperCategory> getDefaultComponentSuperCategoryClass() {
        return TransformSuperCategory.class;
    }

    @Override
    public boolean isDistributableByDefault() {
        return true;
    }
}

