/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.ComponentSuperCategory;
import org.datacleaner.api.Filter;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RenderingFormat;
import org.datacleaner.api.Transformer;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.ClasspathScanDescriptorProvider;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.DescriptorProvider;
import org.datacleaner.descriptors.DescriptorProviderListener;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.descriptors.RendererBeanDescriptor;
import org.datacleaner.descriptors.TransformerDescriptor;

public class CompositeDescriptorProvider
implements DescriptorProvider {
    private final List<DescriptorProvider> delegates = new ArrayList<DescriptorProvider>();
    private final Set<DescriptorProviderListener> activeListeners = new HashSet<DescriptorProviderListener>();

    public void addDelegates(List<DescriptorProvider> descriptorProviders) {
        for (DescriptorProvider descriptorProvider : descriptorProviders) {
            this.addDelegate(descriptorProvider);
        }
    }

    public void addDelegate(DescriptorProvider descriptorProvider) {
        for (DescriptorProviderListener activeListener : this.activeListeners) {
            descriptorProvider.addListener(activeListener);
        }
        this.delegates.add(descriptorProvider);
    }

    public void refresh() {
        for (DescriptorProvider provider : this.delegates) {
            provider.refresh();
        }
    }

    private void removeDuplicateComponents(Collection<? extends ComponentDescriptor<?>> col) {
        HashSet<String> names = new HashSet<String>();
        Iterator<ComponentDescriptor<?>> it = col.iterator();
        while (it.hasNext()) {
            ComponentDescriptor<?> componentDescriptor = it.next();
            boolean newName = names.add(componentDescriptor.getDisplayName());
            if (newName) continue;
            it.remove();
        }
    }

    public Collection<AnalyzerDescriptor<?>> getAnalyzerDescriptors() {
        ArrayList col = new ArrayList();
        for (DescriptorProvider provider : this.delegates) {
            col.addAll(provider.getAnalyzerDescriptors());
        }
        this.removeDuplicateComponents(col);
        return col;
    }

    public <A extends Analyzer<?>> AnalyzerDescriptor<A> getAnalyzerDescriptorForClass(Class<A> analyzerClass) {
        for (DescriptorProvider provider : this.delegates) {
            AnalyzerDescriptor descriptor = provider.getAnalyzerDescriptorForClass(analyzerClass);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public AnalyzerDescriptor<?> getAnalyzerDescriptorByDisplayName(String name) {
        for (DescriptorProvider provider : this.delegates) {
            AnalyzerDescriptor descriptor = provider.getAnalyzerDescriptorByDisplayName(name);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public ComponentDescriptor<?> getComponentDescriptorByDisplayName(String name) {
        for (DescriptorProvider provider : this.delegates) {
            ComponentDescriptor descriptor = provider.getComponentDescriptorByDisplayName(name);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public Collection<TransformerDescriptor<?>> getTransformerDescriptors() {
        ArrayList col = new ArrayList();
        for (DescriptorProvider provider : this.delegates) {
            col.addAll(provider.getTransformerDescriptors());
        }
        this.removeDuplicateComponents(col);
        return col;
    }

    public <T extends Transformer> TransformerDescriptor<T> getTransformerDescriptorForClass(Class<T> transformerClass) {
        for (DescriptorProvider provider : this.delegates) {
            TransformerDescriptor descriptor = provider.getTransformerDescriptorForClass(transformerClass);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public TransformerDescriptor<?> getTransformerDescriptorByDisplayName(String name) {
        for (DescriptorProvider provider : this.delegates) {
            TransformerDescriptor descriptor = provider.getTransformerDescriptorByDisplayName(name);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public Collection<FilterDescriptor<?, ?>> getFilterDescriptors() {
        ArrayList col = new ArrayList();
        for (DescriptorProvider provider : this.delegates) {
            col.addAll(provider.getFilterDescriptors());
        }
        this.removeDuplicateComponents(col);
        return col;
    }

    public <F extends Filter<C>, C extends Enum<C>> FilterDescriptor<F, C> getFilterDescriptorForClass(Class<F> filterClass) {
        for (DescriptorProvider provider : this.delegates) {
            FilterDescriptor descriptor = provider.getFilterDescriptorForClass(filterClass);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public FilterDescriptor<?, ?> getFilterDescriptorByDisplayName(String name) {
        for (DescriptorProvider provider : this.delegates) {
            FilterDescriptor descriptor = provider.getFilterDescriptorByDisplayName(name);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public Set<ComponentSuperCategory> getComponentSuperCategories() {
        TreeSet<ComponentSuperCategory> result = new TreeSet<ComponentSuperCategory>();
        Collection<ComponentDescriptor<?>> descriptors = this.getComponentDescriptors();
        for (ComponentDescriptor<?> componentDescriptor : descriptors) {
            ComponentSuperCategory superCategory = componentDescriptor.getComponentSuperCategory();
            result.add(superCategory);
        }
        return result;
    }

    public Collection<? extends ComponentDescriptor<?>> getComponentDescriptors() {
        ArrayList col = new ArrayList();
        for (DescriptorProvider provider : this.delegates) {
            col.addAll(provider.getComponentDescriptors());
        }
        this.removeDuplicateComponents(col);
        return col;
    }

    public Collection<? extends ComponentDescriptor<?>> getComponentDescriptorsOfSuperCategory(ComponentSuperCategory category) {
        ArrayList col = new ArrayList();
        for (DescriptorProvider provider : this.delegates) {
            col.addAll(provider.getComponentDescriptorsOfSuperCategory(category));
        }
        this.removeDuplicateComponents(col);
        return col;
    }

    public Collection<RendererBeanDescriptor<?>> getRendererBeanDescriptors() {
        ArrayList col = new ArrayList();
        for (DescriptorProvider provider : this.delegates) {
            col.addAll(provider.getRendererBeanDescriptors());
        }
        this.removeDuplicateComponents(col);
        return col;
    }

    public <R extends Renderer<?, ?>> RendererBeanDescriptor<R> getRendererBeanDescriptorForClass(Class<R> rendererBeanClass) {
        for (DescriptorProvider provider : this.delegates) {
            RendererBeanDescriptor descriptor = provider.getRendererBeanDescriptorForClass(rendererBeanClass);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public Collection<RendererBeanDescriptor<?>> getRendererBeanDescriptorsForRenderingFormat(Class<? extends RenderingFormat<?>> renderingFormat) {
        ArrayList col = new ArrayList();
        for (DescriptorProvider provider : this.delegates) {
            col.addAll(provider.getRendererBeanDescriptorsForRenderingFormat(renderingFormat));
        }
        this.removeDuplicateComponents(col);
        return col;
    }

    public void addListener(DescriptorProviderListener listener) {
        this.activeListeners.add(listener);
        for (DescriptorProvider provider : this.delegates) {
            provider.addListener(listener);
        }
    }

    public void removeListener(DescriptorProviderListener listener) {
        this.activeListeners.remove(listener);
        for (DescriptorProvider provider : this.delegates) {
            provider.removeListener(listener);
        }
    }

    public ClasspathScanDescriptorProvider findClasspathScanProvider() {
        for (DescriptorProvider provider : this.delegates) {
            if (!(provider instanceof ClasspathScanDescriptorProvider)) continue;
            return (ClasspathScanDescriptorProvider)provider;
        }
        return null;
    }
}

