/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.lang.reflect.Field;
import org.datacleaner.api.Alias;
import org.datacleaner.api.Configured;
import org.datacleaner.api.Convertable;
import org.datacleaner.api.Converter;
import org.datacleaner.api.Description;
import org.datacleaner.descriptors.AbstractPropertyDescriptor;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.DescriptorException;
import org.datacleaner.descriptors.PropertyDescriptor;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.StringUtils;

final class ConfiguredPropertyDescriptorImpl
extends AbstractPropertyDescriptor
implements ConfiguredPropertyDescriptor {
    private static final long serialVersionUID = 1L;

    protected ConfiguredPropertyDescriptorImpl(Field field, ComponentDescriptor<?> componentDescriptor) throws DescriptorException {
        super(field, componentDescriptor);
    }

    @Override
    public String getName() {
        String value;
        Configured configured = this.getAnnotation(Configured.class);
        if (configured != null && !StringUtils.isNullOrEmpty(value = configured.value())) {
            return value.trim();
        }
        return ReflectionUtils.explodeCamelCase(super.getName(), true);
    }

    public String getDescription() {
        Description desc = this.getAnnotation(Description.class);
        if (desc == null) {
            return null;
        }
        return desc.value();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + "]";
    }

    public boolean isInputColumn() {
        Class<?> baseType = this.getBaseType();
        boolean result = ReflectionUtils.isInputColumn(baseType);
        return result;
    }

    public boolean isRequired() {
        Configured configured = this.getAnnotation(Configured.class);
        if (configured == null) {
            return true;
        }
        return configured.required();
    }

    @Override
    public int compareTo(PropertyDescriptor o) {
        Configured conf2;
        int order2;
        Configured conf1 = this.getAnnotation(Configured.class);
        int order1 = conf1.order();
        int diff = order1 - (order2 = (conf2 = (Configured)o.getAnnotation(Configured.class)) == null ? Integer.MAX_VALUE : conf2.order());
        if (diff == 0) {
            return super.compareTo(o);
        }
        return diff;
    }

    public Converter<?> createCustomConverter() {
        Class<Converter<?>> converterClass = this.getCustomConverterClass();
        if (converterClass != null) {
            try {
                return converterClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private Class<? extends Converter<?>> getCustomConverterClass() {
        Convertable convertable = this.getAnnotation(Convertable.class);
        if (convertable != null) {
            return convertable.value();
        }
        return null;
    }

    public String[] getAliases() {
        Alias alias = this.getAnnotation(Alias.class);
        if (alias == null) {
            return new String[0];
        }
        return alias.value();
    }
}

