/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.lang.annotation.Annotation;
import javax.inject.Named;
import org.apache.metamodel.util.Predicate;
import org.apache.metamodel.util.TruePredicate;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.Filter;
import org.datacleaner.api.Renderer;
import org.datacleaner.api.RendererBean;
import org.datacleaner.api.RenderingFormat;
import org.datacleaner.api.Transformer;
import org.datacleaner.util.ReflectionUtils;
import org.eobjects.analyzer.beans.api.AnalyzerBean;
import org.eobjects.analyzer.beans.api.FilterBean;
import org.eobjects.analyzer.beans.api.TransformerBean;
import org.kohsuke.asm5.AnnotationVisitor;
import org.kohsuke.asm5.Attribute;
import org.kohsuke.asm5.ClassVisitor;
import org.kohsuke.asm5.FieldVisitor;
import org.kohsuke.asm5.MethodVisitor;
import org.kohsuke.asm5.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DCClassVisitor
extends ClassVisitor {
    private static final int API_VERSION = 262144;
    private static final Logger logger = LoggerFactory.getLogger(DCClassVisitor.class);
    private final ClassLoader _classLoader;
    private final Predicate<Class<? extends RenderingFormat<?>>> _renderingFormatPredicate;
    private Class<?> _beanClazz;
    private String _name;

    public DCClassVisitor(ClassLoader classLoader, Predicate<Class<? extends RenderingFormat<?>>> renderingFormatPredicate) {
        super(262144);
        this._classLoader = classLoader;
        this._renderingFormatPredicate = renderingFormatPredicate;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this._name = name;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.isAnnotation(desc, RendererBean.class)) {
            if (this._renderingFormatPredicate == null || this._renderingFormatPredicate instanceof TruePredicate) {
                this.initializeClass();
                return null;
            }
            return new AnnotationVisitor(262144){

                public void visit(String name, Object value) {
                    Class<?> renderingFormatClass;
                    Type valueType = (Type)value;
                    String renderingFormatClassName = valueType.getClassName();
                    try {
                        Class<?> cls;
                        renderingFormatClass = cls = Class.forName(renderingFormatClassName, false, DCClassVisitor.this._classLoader);
                    }
                    catch (Exception e) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Failed to read rendering format of renderer class '" + renderingFormatClassName + "', ignoring: " + DCClassVisitor.this._name, (Throwable)e);
                        }
                        return;
                    }
                    Boolean proceed = (Boolean)DCClassVisitor.this._renderingFormatPredicate.eval(renderingFormatClass);
                    if (proceed == null || !proceed.booleanValue()) {
                        logger.info("Skipping renderer because it's format was not accepted by predicate: {}", (Object)DCClassVisitor.this._name);
                        return;
                    }
                    DCClassVisitor.this.initializeClass();
                }
            };
        }
        if (this.isAnnotation(desc, Named.class)) {
            this.initializeClass();
        } else if (this.isLegacyAnnotation(desc)) {
            logger.info("Initializing class with legacy annotation: {}", (Object)desc);
            this.initializeClass();
        }
        return null;
    }

    private boolean isLegacyAnnotation(String desc) {
        return this.isAnnotation(desc, AnalyzerBean.class) || this.isAnnotation(desc, TransformerBean.class) || this.isAnnotation(desc, FilterBean.class);
    }

    private boolean isAnnotation(String annotationDesc, Class<? extends Annotation> annotationClass) {
        return annotationDesc.indexOf(annotationClass.getName().replace('.', '/')) != -1;
    }

    private Class<?> initializeClass() {
        block6: {
            if (this._beanClazz == null) {
                String javaName = this._name.replace('/', '.');
                try {
                    this._beanClazz = Class.forName(javaName, true, this._classLoader);
                }
                catch (ClassNotFoundException e) {
                    logger.error("Could not find class to be loaded: " + javaName, (Throwable)e);
                }
                catch (NoClassDefFoundError e) {
                    logger.error("Failed to load class {} because of unsatisfied class dependency: {}", (Object)javaName, (Object)e.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to load class: " + javaName, (Throwable)e);
                    }
                }
                catch (UnsupportedClassVersionError e) {
                    logger.error("Failed to load class {} because of unsupported class version: {}", (Object)javaName, (Object)e.getMessage());
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("Failed to load class: " + javaName, (Throwable)e);
                }
            }
        }
        return this._beanClazz;
    }

    public boolean isAnalyzer() {
        if (this._beanClazz != null) {
            return ReflectionUtils.is(this._beanClazz, Analyzer.class);
        }
        return false;
    }

    public boolean isTransformer() {
        if (this._beanClazz != null) {
            return ReflectionUtils.is(this._beanClazz, Transformer.class);
        }
        return false;
    }

    public boolean isRenderer() {
        if (this._beanClazz != null) {
            return ReflectionUtils.isAnnotationPresent(this._beanClazz, RendererBean.class) && ReflectionUtils.is(this._beanClazz, Renderer.class);
        }
        return false;
    }

    public boolean isFilter() {
        if (this._beanClazz != null) {
            return ReflectionUtils.is(this._beanClazz, Filter.class);
        }
        return false;
    }

    public Class<?> getBeanClass() {
        return this._beanClazz;
    }

    public void visitAttribute(Attribute arg0) {
    }

    public void visitEnd() {
    }

    public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
        return null;
    }

    public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
    }

    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        return null;
    }

    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    public void visitSource(String arg0, String arg1) {
    }
}

