/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import java.io.IOException;
import java.io.Serializable;
import org.apache.metamodel.util.HasName;
import org.datacleaner.descriptors.EnumerationProvider;
import org.datacleaner.util.HasAliases;

public class EnumerationValue
implements HasName,
JsonSerializable,
Serializable,
Comparable<EnumerationValue> {
    private static final long serialVersionUID = 1L;
    private final String value;
    private final String name;
    private final String[] aliases;
    private final Enum<?> enumValue;

    public EnumerationValue(String value, String name) {
        this(value, name, null);
    }

    public EnumerationValue(String enumValue, String enumName, String[] enumAliases) {
        this.value = enumValue;
        this.name = enumName == null ? "" : enumName;
        this.aliases = enumAliases == null ? new String[]{} : enumAliases;
        this.enumValue = null;
    }

    public EnumerationValue(String value) {
        this(value, value);
    }

    public EnumerationValue(Enum<?> value) {
        String nameCandidate;
        this.enumValue = value;
        this.value = this.enumValue.name();
        this.name = this.enumValue instanceof HasName ? ((nameCandidate = ((HasName)this.enumValue).getName()) == null ? "" : nameCandidate) : value.toString();
        this.aliases = this.enumValue instanceof HasAliases ? ((HasAliases)this.enumValue).getAliases() : new String[0];
    }

    public Enum<?> asJavaEnum() {
        return this.enumValue;
    }

    public String getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeString(this.value);
    }

    public void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        jgen.writeString(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnumerationValue that = (EnumerationValue)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public static EnumerationValue[] fromArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof EnumerationValue[]) {
            return (EnumerationValue[])value;
        }
        if (value != null && value.getClass().isArray() && value.getClass().getComponentType().isEnum()) {
            Enum[] values = (Enum[])value;
            EnumerationValue[] result = new EnumerationValue[values.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new EnumerationValue(values[i]);
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported enumeration value array: " + (value == null ? null : value.getClass()));
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public static EnumerationProvider providerFromEnumClass(Class<? extends Enum<?>> enumClass) {
        final EnumerationValue[] values = EnumerationValue.fromArray(enumClass.getEnumConstants());
        return new EnumerationProvider(){

            @Override
            public EnumerationValue[] values() {
                return values;
            }

            @Override
            public EnumerationValue forString(String value) {
                for (EnumerationValue candidate : values) {
                    if (value.equals(candidate.getValue()) || value.equals(candidate.getName())) {
                        return candidate;
                    }
                    for (String alias : candidate.getAliases()) {
                        if (!value.equals(alias)) continue;
                        return candidate;
                    }
                }
                return null;
            }
        };
    }

    @Override
    public int compareTo(EnumerationValue o) {
        Enum<?> javaEnum2 = o.asJavaEnum();
        if (this.enumValue != null && javaEnum2 != null) {
            try {
                Enum<?> javaEnum1 = this.asJavaEnum();
                int result = javaEnum1.compareTo(javaEnum2);
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getName().compareTo(o.getName());
    }
}

