/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.descriptors;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Metric;
import org.datacleaner.api.ParameterizableMetric;
import org.datacleaner.descriptors.AbstractMetricDescriptor;
import org.datacleaner.descriptors.MetricDescriptor;
import org.datacleaner.descriptors.MetricParameters;
import org.datacleaner.util.ReflectionUtils;
import org.datacleaner.util.StringUtils;

final class MetricDescriptorImpl
extends AbstractMetricDescriptor
implements MetricDescriptor {
    private static final long serialVersionUID = 1L;
    private final transient Method _method;
    private final String _name;
    private final Class<? extends AnalyzerResult> _resultClass;
    private final String _methodName;

    public MetricDescriptorImpl(Class<? extends AnalyzerResult> resultClass, Method method) {
        this._resultClass = resultClass;
        this._method = method;
        this._method.setAccessible(true);
        String metricName = ReflectionUtils.getAnnotation(this._method, Metric.class).value();
        if (StringUtils.isNullOrEmpty(metricName)) {
            throw new IllegalStateException("Metric method has no name: " + this._method);
        }
        this._name = metricName.trim();
        this._methodName = this._method.getName();
    }

    public Method getMethod() {
        if (this._method == null) {
            Method method = ReflectionUtils.getMethod(this._resultClass, this._methodName, true);
            if (method == null) {
                throw new IllegalStateException("No such method: " + this._methodName + " in " + this._resultClass);
            }
            return method;
        }
        return this._method;
    }

    public String getName() {
        return this._name;
    }

    public Class<? extends AnalyzerResult> getResultClass() {
        return this._resultClass;
    }

    public Collection<String> getMetricParameterSuggestions(AnalyzerResult result) {
        Method method = this.getMethod();
        Class<?> returnType = method.getReturnType();
        if (ReflectionUtils.is(returnType, ParameterizableMetric.class)) {
            Object[] methodParameters = this.createMethodParameters(method, null);
            try {
                Object returnValue = method.invoke((Object)result, methodParameters);
                ParameterizableMetric parameterizableMetric = (ParameterizableMetric)returnValue;
                return parameterizableMetric.getParameterSuggestions();
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not invoke metric getter " + this._methodName, e);
            }
        }
        return Collections.emptyList();
    }

    public Number getValue(AnalyzerResult result, MetricParameters metricParameters) {
        if (result == null) {
            throw new IllegalArgumentException("AnalyzerResult cannot be null");
        }
        Method method = this.getMethod();
        Object[] methodParameters = this.createMethodParameters(method, metricParameters);
        try {
            Number number;
            Object returnValue = method.invoke((Object)result, methodParameters);
            if (returnValue instanceof ParameterizableMetric) {
                ParameterizableMetric parameterizableMetric = (ParameterizableMetric)returnValue;
                number = parameterizableMetric.getValue(metricParameters.getQueryString());
            } else {
                number = (Number)returnValue;
            }
            return number;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not invoke metric getter " + this._methodName, e);
        }
    }

    private Object[] createMethodParameters(Method method, MetricParameters metricParameters) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return null;
        }
        Object[] result = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (String.class == parameterTypes[i]) {
                result[i] = metricParameters.getQueryString();
                continue;
            }
            if (InputColumn.class == parameterTypes[i]) {
                result[i] = metricParameters.getQueryInputColumn();
                continue;
            }
            throw new IllegalStateException("Unsupported metric parameter type: " + parameterTypes[i]);
        }
        return result;
    }

    public boolean isParameterizedByInputColumn() {
        Method method = this.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return false;
        }
        for (Class<?> parameterType : parameterTypes) {
            if (InputColumn.class != parameterType) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterizedByString() {
        Method method = this.getMethod();
        Class<?> returnType = method.getReturnType();
        if (ReflectionUtils.is(returnType, ParameterizableMetric.class)) {
            return true;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes == null || parameterTypes.length == 0) {
            return false;
        }
        for (Class<?> parameterType : parameterTypes) {
            if (String.class != parameterType) continue;
            return true;
        }
        return false;
    }

    public Set<Annotation> getAnnotations() {
        Annotation[] annotations = this.getMethod().getAnnotations();
        return new HashSet<Annotation>(Arrays.asList(annotations));
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return ReflectionUtils.getAnnotation(this.getMethod(), annotationClass);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._resultClass == null ? 0 : this._resultClass.hashCode());
        result = 31 * result + (this._methodName == null ? 0 : this._methodName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricDescriptorImpl other = (MetricDescriptorImpl)obj;
        if (this._resultClass == null ? other._resultClass != null : !this._resultClass.equals(other._resultClass)) {
            return false;
        }
        return !(this._methodName == null ? other._methodName != null : !this._methodName.equals(other._methodName));
    }
}

