/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.extensions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassLoaderUtils {
    private static final Logger logger = LoggerFactory.getLogger(ClassLoaderUtils.class);
    public static final boolean IS_WEB_START = System.getProperty("javawebstart.version") != null;

    private ClassLoaderUtils() {
    }

    public static ClassLoader getParentClassLoader() {
        logger.debug("getParentClassLoader() invoked, web start mode: {}", (Object)IS_WEB_START);
        if (IS_WEB_START) {
            return Thread.currentThread().getContextClassLoader();
        }
        return ClassLoaderUtils.class.getClassLoader();
    }

    public static ClassLoader createClassLoader(File[] files) {
        return ClassLoaderUtils.createClassLoader(files, ClassLoaderUtils.getParentClassLoader());
    }

    public static ClassLoader createClassLoader(File[] files, ClassLoader parentClassLoader) {
        try {
            URL[] urls = new URL[files.length];
            for (int i = 0; i < urls.length; ++i) {
                URL url = files[i].toURI().toURL();
                logger.debug("Using URL: {}", (Object)url);
                urls[i] = url;
            }
            return ClassLoaderUtils.createClassLoader(urls, parentClassLoader);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ClassLoader createClassLoader(URL[] urls) {
        return ClassLoaderUtils.createClassLoader(urls, ClassLoaderUtils.getParentClassLoader());
    }

    public static ClassLoader createClassLoader(URL[] urls, ClassLoader parentClassLoader) {
        System.setSecurityManager(null);
        return AccessController.doPrivileged(() -> new URLClassLoader(urls, parentClassLoader));
    }
}

