/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.extensions;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import org.apache.metamodel.util.FileHelper;
import org.datacleaner.extensions.ExtensionPackage;
import org.datacleaner.util.FileFilters;
import org.datacleaner.util.ResourceManager;
import org.datacleaner.util.StringUtils;
import org.datacleaner.util.http.HttpXmlUtils;
import org.datacleaner.util.xml.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtensionReader {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionReader.class);
    private final ResourceManager resourceManager = ResourceManager.get();

    public List<ExtensionPackage> getInternalExtensions() {
        List<URL> extensionDescriptorUrls = this.resourceManager.getUrls("datacleaner-extension.xml", new ClassLoader[0]);
        ArrayList<ExtensionPackage> result = new ArrayList<ExtensionPackage>();
        for (URL url : extensionDescriptorUrls) {
            ExtensionPackage extension = this.getInternalExtension(url);
            if (extension == null) continue;
            result.add(extension);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtensionPackage getInternalExtension(URL url) {
        ExtensionPackage extensionPackage;
        logger.info("Reading extension descriptor: {}", (Object)url);
        InputStream inputStream = url.openStream();
        try {
            extensionPackage = this.readExtension(inputStream, new File[0]);
        }
        catch (Throwable throwable) {
            try {
                FileHelper.safeClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            catch (Exception e) {
                logger.error("Error reading internal extension of URL: " + url, (Throwable)e);
                return null;
            }
        }
        FileHelper.safeClose((Object[])new Object[]{inputStream});
        return extensionPackage;
    }

    public ExtensionPackage readExternalExtension(File fileOrDirectory) {
        if (fileOrDirectory == null) {
            return null;
        }
        if (!fileOrDirectory.isDirectory()) {
            return this.readExternalExtension(new File[]{fileOrDirectory});
        }
        return this.readExternalExtension(fileOrDirectory.getName(), new File[]{fileOrDirectory});
    }

    public ExtensionPackage readExternalExtension(File[] files) {
        return this.readExternalExtension(null, files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public ExtensionPackage readExternalExtension(String name, File[] files) {
        String extensionName;
        boolean autoDetectPackage;
        File[] jarFiles;
        if (files.length == 1 && files[0].isDirectory()) {
            jarFiles = files[0].listFiles(FileFilters.JAR);
            autoDetectPackage = false;
        } else {
            jarFiles = files;
            autoDetectPackage = true;
        }
        if (jarFiles.length == 0) {
            return null;
        }
        for (File file : jarFiles) {
            if (!file.getName().toLowerCase().endsWith(".jar")) continue;
            try {
                Throwable throwable = null;
                try (JarFile jarFile = new JarFile(file);){
                    ExtensionPackage extensionPackage;
                    JarEntry entry = jarFile.getJarEntry("datacleaner-extension.xml");
                    if (entry == null) {
                        logger.info("No extension descriptor file (datacleaner-extension.xml) found in file: {}", (Object)file);
                        continue;
                    }
                    InputStream inputStream = jarFile.getInputStream(entry);
                    try {
                        ExtensionPackage extension;
                        extensionPackage = extension = this.readExtension(name, inputStream, jarFiles);
                    }
                    catch (Throwable throwable2) {
                        try {
                            FileHelper.safeClose((Object[])new Object[]{inputStream});
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                    FileHelper.safeClose((Object[])new Object[]{inputStream});
                    return extensionPackage;
                }
            }
            catch (Exception e) {
                logger.error("Failed to read from JAR file", (Throwable)e);
            }
        }
        if (StringUtils.isNullOrEmpty(name)) {
            StringBuilder extensionNameBuilder = new StringBuilder();
            for (File file : files) {
                if (extensionNameBuilder.length() > 0) {
                    extensionNameBuilder.append(", ");
                }
                extensionNameBuilder.append(file.getName());
            }
            extensionName = extensionNameBuilder.toString();
        } else {
            extensionName = name;
        }
        String packageName = autoDetectPackage ? this.autoDetectPackageName(jarFiles[0]) : "";
        ExtensionPackage extension = new ExtensionPackage(extensionName, packageName, true, files);
        return extension;
    }

    private ExtensionPackage readExtension(InputStream inputStream, File[] files) throws Exception {
        return this.readExtension(null, inputStream, files);
    }

    private ExtensionPackage readExtension(String name, InputStream inputStream, File[] files) throws Exception {
        String url;
        String icon;
        String version;
        DocumentBuilder documentBuilder = XmlUtils.createDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        Element documentElement = document.getDocumentElement();
        if (StringUtils.isNullOrEmpty(name)) {
            name = HttpXmlUtils.getChildNodeText(documentElement, "name");
        }
        String scanPackage = HttpXmlUtils.getChildNodeText(documentElement, "package");
        ExtensionPackage extensionPackage = new ExtensionPackage(name, scanPackage, true, files);
        String description = HttpXmlUtils.getChildNodeText(documentElement, "description");
        if (!StringUtils.isNullOrEmpty(description)) {
            extensionPackage.getAdditionalProperties().put("description", description);
        }
        if (!StringUtils.isNullOrEmpty(version = HttpXmlUtils.getChildNodeText(documentElement, "version"))) {
            extensionPackage.getAdditionalProperties().put("version", version);
        }
        if (!StringUtils.isNullOrEmpty(icon = HttpXmlUtils.getChildNodeText(documentElement, "icon"))) {
            extensionPackage.getAdditionalProperties().put("icon", icon);
        }
        if (!StringUtils.isNullOrEmpty(url = HttpXmlUtils.getChildNodeText(documentElement, "url"))) {
            extensionPackage.getAdditionalProperties().put("url", url);
        }
        String author = HttpXmlUtils.getChildNodeText(documentElement, "author");
        if (!StringUtils.isNullOrEmpty(url)) {
            extensionPackage.getAdditionalProperties().put("author", author);
        }
        return extensionPackage;
    }

    public String autoDetectPackageName(File file) {
        try {
            HashSet<String> packageNames = new HashSet<String>();
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".class")) continue;
                    logger.debug("Considering package of entry '{}'", (Object)name);
                    int lastIndexOfSlash = name.lastIndexOf(47);
                    if (lastIndexOfSlash == -1) continue;
                    name = name.substring(0, lastIndexOfSlash);
                    packageNames.add(name);
                }
            }
            if (packageNames.isEmpty()) {
                return null;
            }
            logger.info("Found {} packages in extension jar: {}", (Object)packageNames.size(), packageNames);
            String packageName = StringUtils.getLongestCommonToken(packageNames, '/');
            if (packageName == "") {
                logger.debug("No common package prefix");
                return null;
            }
            packageName = packageName.replace('/', '.');
            return packageName;
        }
        catch (Exception e) {
            logger.warn("Error occurred while auto detecting package name", (Throwable)e);
            return null;
        }
    }
}

