/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.CompoundComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.ImmutableFilterOutcome;
import org.datacleaner.job.ImmutableOutputDataStreamJob;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.LazyFilterOutcome;
import org.datacleaner.job.builder.LazyOutputDataStreamJob;
import org.datacleaner.job.builder.TransformerComponentBuilder;

public final class AnalysisJobImmutabilizer {
    private final Map<LazyFilterOutcome, ImmutableFilterOutcome> _outcomes = new HashMap<LazyFilterOutcome, ImmutableFilterOutcome>();
    private final Map<ComponentBuilder, ComponentJob> _componentJobs = new IdentityHashMap<ComponentBuilder, ComponentJob>();

    public OutputDataStreamJob[] load(OutputDataStreamJob[] outputDataStreamJobs, boolean validate) {
        if (outputDataStreamJobs == null || outputDataStreamJobs.length == 0) {
            return outputDataStreamJobs;
        }
        OutputDataStreamJob[] result = new OutputDataStreamJob[outputDataStreamJobs.length];
        for (int i = 0; i < result.length; ++i) {
            OutputDataStreamJob outputDataStreamJob = outputDataStreamJobs[i];
            if (outputDataStreamJob instanceof LazyOutputDataStreamJob) {
                OutputDataStream outputDataStream = outputDataStreamJob.getOutputDataStream();
                AnalysisJob job = ((LazyOutputDataStreamJob)outputDataStreamJob).getJob(validate, this);
                result[i] = new ImmutableOutputDataStreamJob(outputDataStream, job);
                continue;
            }
            result[i] = outputDataStreamJob;
        }
        return result;
    }

    public FilterOutcome load(FilterOutcome outcome) {
        if (outcome instanceof LazyFilterOutcome) {
            LazyFilterOutcome lfo = (LazyFilterOutcome)outcome;
            ImmutableFilterOutcome result = this._outcomes.get((Object)lfo);
            if (result == null) {
                result = new ImmutableFilterOutcome(lfo.getFilterJob(), lfo.getCategory());
                this._outcomes.put(lfo, result);
            }
            return result;
        }
        return outcome;
    }

    public ComponentRequirement load(ComponentRequirement req) {
        if (req instanceof SimpleComponentRequirement) {
            FilterOutcome originalOutcome = ((SimpleComponentRequirement)req).getOutcome();
            FilterOutcome loadedOutcome = this.load(originalOutcome);
            if (loadedOutcome != originalOutcome) {
                return new SimpleComponentRequirement(loadedOutcome);
            }
        } else if (req instanceof CompoundComponentRequirement) {
            boolean changed = false;
            CompoundComponentRequirement componentRequirement = (CompoundComponentRequirement)req;
            Set<FilterOutcome> originalOutcomes = componentRequirement.getOutcomes();
            ArrayList<FilterOutcome> loadedOutcomes = new ArrayList<FilterOutcome>(originalOutcomes.size());
            for (FilterOutcome originalOutcome : originalOutcomes) {
                FilterOutcome loadedOutcome = this.load(originalOutcome);
                if (loadedOutcome != originalOutcome) {
                    changed = true;
                }
                loadedOutcomes.add(loadedOutcome);
            }
            if (changed) {
                return new CompoundComponentRequirement(loadedOutcomes);
            }
        }
        return req;
    }

    public TransformerJob getOrCreateTransformerJob(boolean validate, TransformerComponentBuilder<?> tjb) {
        TransformerJob componentJob = (TransformerJob)this._componentJobs.get(tjb);
        if (componentJob == null) {
            try {
                componentJob = tjb.toTransformerJob(validate, this);
                this._componentJobs.put(tjb, (ComponentJob)componentJob);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Could not create transformer job from builder: " + tjb + ", (" + e.getMessage() + ")", e);
            }
        }
        return componentJob;
    }
}

