/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.metamodel.util.Predicate;
import org.datacleaner.api.InputColumn;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.util.CollectionUtils2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerJobHelper {
    private static final Logger logger = LoggerFactory.getLogger(AnalyzerJobHelper.class);
    private final Collection<AnalyzerJob> _jobs;

    public AnalyzerJobHelper(Collection<AnalyzerJob> jobs) {
        this._jobs = jobs;
    }

    public AnalyzerJobHelper(AnalysisJob analysisJob) {
        this(analysisJob.flattened().flatMap(analysisJob1 -> analysisJob1.getAnalyzerJobs().stream()).collect(Collectors.toList()));
    }

    public Collection<AnalyzerJob> getAnalyzerJobs() {
        return this._jobs;
    }

    public AnalyzerJob getAnalyzerJob(AnalyzerJob analyzerJob) {
        if (this._jobs.contains(analyzerJob)) {
            return analyzerJob;
        }
        InputColumn<?> inputColumn = AnalyzerJobHelper.getIdentifyingInputColumn((ComponentJob)analyzerJob);
        String analyzerInputName = inputColumn == null ? null : inputColumn.getName();
        return this.getAnalyzerJob(analyzerJob.getDescriptor().getDisplayName(), analyzerJob.getName(), analyzerInputName);
    }

    public AnalyzerJob getAnalyzerJob(final String descriptorName, final String analyzerName, final String analyzerInputName) {
        List<AnalyzerJob> candidates = new ArrayList<AnalyzerJob>(this._jobs);
        candidates = CollectionUtils2.refineCandidates(candidates, new Predicate<AnalyzerJob>(){

            public Boolean eval(AnalyzerJob o) {
                String actualDescriptorName = o.getDescriptor().getDisplayName();
                return descriptorName.equals(actualDescriptorName);
            }
        });
        if (analyzerName != null) {
            candidates = CollectionUtils2.refineCandidates(candidates, new Predicate<AnalyzerJob>(){

                public Boolean eval(AnalyzerJob o) {
                    String actualAnalyzerName = o.getName();
                    return analyzerName.equals(actualAnalyzerName);
                }
            });
        }
        if (analyzerInputName != null) {
            candidates = CollectionUtils2.refineCandidates(candidates, new Predicate<AnalyzerJob>(){

                public Boolean eval(AnalyzerJob o) {
                    InputColumn<?> inputColumn = AnalyzerJobHelper.getIdentifyingInputColumn((ComponentJob)o);
                    if (inputColumn == null) {
                        return false;
                    }
                    return analyzerInputName.equals(inputColumn.getName());
                }
            });
        }
        if (candidates.isEmpty()) {
            logger.error("No more AnalyzerJob candidates to choose from");
            return null;
        }
        if (candidates.size() > 1) {
            logger.warn("Multiple ({}) AnalyzerJob candidates to choose from, picking first");
        }
        AnalyzerJob analyzerJob = candidates.iterator().next();
        return analyzerJob;
    }

    public static InputColumn<?> getIdentifyingInputColumn(ComponentJob o) {
        ComponentDescriptor descriptor = o.getDescriptor();
        Set inputProperties = descriptor.getConfiguredPropertiesForInput(false);
        if (inputProperties.size() != 1) {
            return null;
        }
        ConfiguredPropertyDescriptor inputProperty = (ConfiguredPropertyDescriptor)inputProperties.iterator().next();
        Object input = o.getConfiguration().getProperty(inputProperty);
        if (input instanceof InputColumn) {
            InputColumn inputColumn = (InputColumn)input;
            return inputColumn;
        }
        if (input instanceof InputColumn[]) {
            InputColumn[] inputColumns = (InputColumn[])input;
            if (inputColumns.length != 1) {
                return null;
            }
            return inputColumns[0];
        }
        return null;
    }
}

