/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.FilterOutcomes;
import org.datacleaner.job.HasFilterOutcomes;

public class CompoundComponentRequirement
implements ComponentRequirement {
    private static final long serialVersionUID = 1L;
    private final Set<FilterOutcome> _outcomes;

    public CompoundComponentRequirement(Collection<? extends FilterOutcome> outcomes) {
        this._outcomes = new LinkedHashSet<FilterOutcome>(outcomes);
    }

    public CompoundComponentRequirement(FilterOutcome ... outcomes) {
        this._outcomes = new LinkedHashSet<FilterOutcome>();
        Collections.addAll(this._outcomes, outcomes);
    }

    public CompoundComponentRequirement(ComponentRequirement existingRequirement, FilterOutcome filterOutcome) {
        this._outcomes = new LinkedHashSet<FilterOutcome>();
        this._outcomes.addAll(existingRequirement.getProcessingDependencies());
        this._outcomes.add(filterOutcome);
    }

    public Set<FilterOutcome> getOutcomes() {
        return this._outcomes;
    }

    public Set<FilterOutcome> getOutcomesFrom(HasFilterOutcomes producingComponent) {
        LinkedHashSet<FilterOutcome> result = new LinkedHashSet<FilterOutcome>();
        for (FilterOutcome outcome : this._outcomes) {
            HasFilterOutcomes source = outcome.getSource();
            if (!producingComponent.equals(source)) continue;
            result.add(outcome);
        }
        return result;
    }

    public boolean hasMultipleRequirementsFrom(HasFilterOutcomes producingComponent) {
        int count = 0;
        for (FilterOutcome outcome : this._outcomes) {
            HasFilterOutcomes source = outcome.getSource();
            if (!producingComponent.equals(source)) continue;
            ++count;
        }
        return count > 1;
    }

    public Collection<FilterOutcome> getProcessingDependencies() {
        return this.getOutcomes();
    }

    public boolean isSatisfied(InputRow row, FilterOutcomes outcomes) {
        for (FilterOutcome outcome : outcomes.getOutcomes()) {
            if (!this._outcomes.contains(outcome)) continue;
            return true;
        }
        return false;
    }

    public String getSimpleName() {
        StringBuilder sb = new StringBuilder();
        for (FilterOutcome outcome : this._outcomes) {
            if (sb.length() != 0) {
                sb.append(" OR ");
            }
            sb.append(outcome.getSimpleName());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FilterOutcome outcome : this._outcomes) {
            if (sb.length() != 0) {
                sb.append(" OR ");
            }
            sb.append(outcome.toString());
        }
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this._outcomes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundComponentRequirement other = (CompoundComponentRequirement)obj;
        return Objects.equals(this._outcomes, other._outcomes);
    }
}

