/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.metamodel.util.BaseObject;
import org.datacleaner.api.InputColumn;
import org.datacleaner.connection.Datastore;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalysisJobMetadata;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.TransformerJob;

public final class ImmutableAnalysisJob
extends BaseObject
implements AnalysisJob {
    private final Datastore _datastore;
    private final List<InputColumn<?>> _sourceColumns;
    private final List<TransformerJob> _transformerJobs;
    private final List<AnalyzerJob> _analyzerJobs;
    private final List<FilterJob> _filterJobs;
    private final AnalysisJobMetadata _metadata;

    @Deprecated
    public ImmutableAnalysisJob(Datastore datastore, Collection<? extends InputColumn<?>> sourceColumns, Collection<FilterJob> filterJobs, Collection<TransformerJob> transformerJobs, Collection<AnalyzerJob> analyzerJobs) {
        this(AnalysisJobMetadata.EMPTY_METADATA, datastore, sourceColumns, filterJobs, transformerJobs, analyzerJobs);
    }

    public ImmutableAnalysisJob(AnalysisJobMetadata metadata, Datastore datastore, Collection<? extends InputColumn<?>> sourceColumns, Collection<FilterJob> filterJobs, Collection<TransformerJob> transformerJobs, Collection<AnalyzerJob> analyzerJobs) {
        this._metadata = metadata;
        this._datastore = datastore;
        this._sourceColumns = ImmutableList.copyOf(sourceColumns);
        this._transformerJobs = ImmutableList.copyOf(transformerJobs);
        this._analyzerJobs = ImmutableList.copyOf(analyzerJobs);
        this._filterJobs = ImmutableList.copyOf(filterJobs);
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._datastore);
        identifiers.add(this._sourceColumns);
        identifiers.add(this._transformerJobs);
        identifiers.add(this._analyzerJobs);
        identifiers.add(this._filterJobs);
    }

    public AnalysisJobMetadata getMetadata() {
        if (this._metadata == null) {
            return AnalysisJobMetadata.EMPTY_METADATA;
        }
        return this._metadata;
    }

    public Datastore getDatastore() {
        return this._datastore;
    }

    public List<InputColumn<?>> getSourceColumns() {
        return this._sourceColumns;
    }

    public List<TransformerJob> getTransformerJobs() {
        return this._transformerJobs;
    }

    public List<AnalyzerJob> getAnalyzerJobs() {
        return this._analyzerJobs;
    }

    public List<FilterJob> getFilterJobs() {
        return this._filterJobs;
    }

    public String toString() {
        return "ImmutableAnalysisJob[sourceColumns=" + this._sourceColumns.size() + ",filterJobs=" + this._filterJobs.size() + ",transformerJobs=" + this._transformerJobs.size() + ",analyzerJobs=" + this._analyzerJobs.size() + "]";
    }
}

