/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.util.BaseObject;
import org.datacleaner.api.InputColumn;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.util.CollectionUtils2;
import org.datacleaner.util.ReadObjectBuilder;

public class ImmutableComponentJob
extends BaseObject
implements ComponentJob {
    private static final long serialVersionUID = 1L;
    @ReadObjectBuilder.Moved
    private final String _name;
    @ReadObjectBuilder.Moved
    private final ComponentDescriptor<?> _descriptor;
    @ReadObjectBuilder.Moved
    private final ComponentConfiguration _beanConfiguration;
    @ReadObjectBuilder.Moved
    private final ComponentRequirement _componentRequirement;
    @ReadObjectBuilder.Moved
    private final Map<String, String> _metadataProperties;
    private final OutputDataStreamJob[] _outputDataStreamJobs;

    public ImmutableComponentJob(String name, ComponentDescriptor<?> descriptor, ComponentConfiguration componentConfiguration, ComponentRequirement componentRequirement, Map<String, String> metadataProperties, OutputDataStreamJob[] outputDataStreamJobs) {
        this._name = name;
        this._descriptor = descriptor;
        this._beanConfiguration = componentConfiguration;
        this._componentRequirement = componentRequirement;
        this._outputDataStreamJobs = outputDataStreamJobs;
        this._metadataProperties = metadataProperties == null ? Collections.emptyMap() : ImmutableMap.copyOf(metadataProperties);
    }

    public ImmutableComponentJob(String name, ComponentDescriptor<?> descriptor, ComponentConfiguration componentConfiguration, ComponentRequirement componentRequirement, Map<String, String> metadataProperties) {
        this(name, descriptor, componentConfiguration, componentRequirement, metadataProperties, null);
    }

    public final Map<String, String> getMetadataProperties() {
        return this._metadataProperties;
    }

    public final ComponentRequirement getComponentRequirement() {
        return this._componentRequirement;
    }

    public final String getName() {
        return this._name;
    }

    public ComponentDescriptor<?> getDescriptor() {
        return this._descriptor;
    }

    public final ComponentConfiguration getConfiguration() {
        return this._beanConfiguration;
    }

    public final InputColumn<?>[] getInput() {
        ArrayList<InputColumn> result = new ArrayList<InputColumn>();
        Set propertiesForInput = this._descriptor.getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor propertyDescriptor : propertiesForInput) {
            Object property = this._beanConfiguration.getProperty(propertyDescriptor);
            InputColumn[] inputs = CollectionUtils2.arrayOf(InputColumn.class, property);
            if (inputs == null) continue;
            for (InputColumn inputColumn : inputs) {
                result.add(inputColumn);
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    protected void decorateIdentity(List<Object> identifiers) {
        identifiers.add(this._name);
        identifiers.add(this._beanConfiguration);
        identifiers.add(this._descriptor);
        identifiers.add(this._componentRequirement);
        identifiers.add(this._outputDataStreamJobs);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[name=" + this.getName() + ",type=" + this.getDescriptor().getDisplayName() + "]";
    }

    public OutputDataStreamJob[] getOutputDataStreamJobs() {
        if (this._outputDataStreamJobs == null) {
            return new OutputDataStreamJob[0];
        }
        return Arrays.copyOf(this._outputDataStreamJobs, this._outputDataStreamJobs.length);
    }
}

