/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job;

import java.util.Arrays;
import java.util.Collection;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.FilterOutcomes;
import org.datacleaner.util.LabelUtils;

public class SimpleComponentRequirement
implements ComponentRequirement {
    private static final long serialVersionUID = 1L;
    private final FilterOutcome _outcome;

    public SimpleComponentRequirement(FilterOutcome outcome) {
        if (outcome == null) {
            throw new IllegalArgumentException("FilterOutcome cannot be null");
        }
        this._outcome = outcome;
    }

    public FilterOutcome getOutcome() {
        return this._outcome;
    }

    public Collection<FilterOutcome> getProcessingDependencies() {
        return Arrays.asList(this._outcome);
    }

    public boolean isSatisfied(InputRow row, FilterOutcomes outcomes) {
        return outcomes.contains(this._outcome);
    }

    public String toString() {
        String filterLabel = LabelUtils.getLabel((ComponentJob)this._outcome.getFilterJob());
        return filterLabel + "=" + this._outcome.getCategory();
    }

    public String getSimpleName() {
        return this._outcome.getCategory() + "";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._outcome == null ? 0 : this._outcome.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleComponentRequirement other = (SimpleComponentRequirement)obj;
        return !(this._outcome == null ? other._outcome != null : !this._outcome.equals(other._outcome));
    }
}

