/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.EqualsBuilder;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.HasNameMapper;
import org.datacleaner.api.Component;
import org.datacleaner.api.HasDistributionAdvice;
import org.datacleaner.api.HasOutputDataStreams;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.MappedProperty;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.api.Renderable;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.connection.OutputDataStreamDatastore;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.data.TransformedInputColumn;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.descriptors.FilterDescriptor;
import org.datacleaner.descriptors.RemoteDescriptorProvider;
import org.datacleaner.descriptors.RemoteTransformerDescriptor;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.ComponentValidationException;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.ImmutableComponentConfiguration;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.job.SimpleComponentRequirement;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.ComponentBuilderTransformerChangeListener;
import org.datacleaner.job.builder.ComponentRemovalListener;
import org.datacleaner.job.builder.FilterComponentBuilder;
import org.datacleaner.job.builder.LazyOutputDataStreamJob;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.job.builder.UnconfiguredConfiguredPropertyException;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.CollectionUtils2;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentBuilder<D extends ComponentDescriptor<E>, E extends Component, B extends ComponentBuilder>
implements ComponentBuilder,
Renderable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponentBuilder.class);
    private final List<ComponentRemovalListener<ComponentBuilder>> _removalListeners;
    private final List<OutputDataStream> _outputDataStreams = new ArrayList<OutputDataStream>();
    private final Map<OutputDataStream, AnalysisJobBuilder> _outputDataStreamJobs = new HashMap<OutputDataStream, AnalysisJobBuilder>();
    private final D _descriptor;
    private final E _configurableBean;
    private final Map<String, String> _metadataProperties;
    private AnalysisJobBuilder _analysisJobBuilder;
    private ComponentRequirement _componentRequirement;
    private String _name;

    public AbstractComponentBuilder(AnalysisJobBuilder analysisJobBuilder, D descriptor, Class<?> builderClass) {
        if (analysisJobBuilder == null) {
            throw new IllegalArgumentException("analysisJobBuilder cannot be null");
        }
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        if (builderClass == null) {
            throw new IllegalArgumentException("builderClass cannot be null");
        }
        this._analysisJobBuilder = analysisJobBuilder;
        this._descriptor = descriptor;
        if (!ReflectionUtils.is(this.getClass(), builderClass)) {
            throw new IllegalArgumentException("Builder class does not correspond to actual class of builder");
        }
        this._configurableBean = (Component)this._descriptor.newInstance();
        this._metadataProperties = new LinkedHashMap<String, String>();
        this.initMetadataProperties();
        this._removalListeners = new ArrayList<ComponentRemovalListener<ComponentBuilder>>(1);
    }

    private void initMetadataProperties() {
        if (this._descriptor instanceof RemoteTransformerDescriptor) {
            RemoteDescriptorProvider remoteDescriptorProvider = ((RemoteTransformerDescriptor)this._descriptor).getRemoteDescriptorProvider();
            String source = remoteDescriptorProvider.getServerData().getServerName();
            this._metadataProperties.put("source", source);
        }
    }

    @Override
    public final Map<String, String> getMetadataProperties() {
        return this._metadataProperties;
    }

    @Override
    public final String getMetadataProperty(String key) {
        return this._metadataProperties.get(key);
    }

    @Override
    public final void setMetadataProperty(String key, String value) {
        this._metadataProperties.put(key, value);
    }

    @Override
    public void setMetadataProperties(Map<String, String> metadataProperties) {
        this._metadataProperties.clear();
        this.initMetadataProperties();
        if (metadataProperties != null) {
            this._metadataProperties.putAll(metadataProperties);
        }
    }

    @Override
    public final void removeMetadataProperty(String key) {
        this._metadataProperties.remove(key);
    }

    @Override
    public final AnalysisJobBuilder getAnalysisJobBuilder() {
        return this._analysisJobBuilder;
    }

    public final D getDescriptor() {
        return this._descriptor;
    }

    public final E getComponentInstance() {
        return this._configurableBean;
    }

    @Deprecated
    public final E getConfigurableBean() {
        return this.getComponentInstance();
    }

    @Override
    public void setConfiguredProperties(Map<ConfiguredPropertyDescriptor, Object> configuredProperties) {
        boolean changed = false;
        for (Map.Entry<ConfiguredPropertyDescriptor, Object> entry : configuredProperties.entrySet()) {
            changed = this.setConfiguredPropertyIfChanged(entry.getKey(), entry.getValue()) || changed;
        }
        if (changed) {
            this.onConfigurationChanged();
        }
    }

    @Override
    public void setConfiguredProperties(ComponentConfiguration configuration) {
        boolean changed = false;
        Set properties = this.getDescriptor().getConfiguredProperties();
        for (ConfiguredPropertyDescriptor property : properties) {
            Object value;
            boolean changedValue = this.setConfiguredPropertyIfChanged(property, value = configuration.getProperty(property));
            if (!changedValue) continue;
            changed = true;
        }
        if (changed) {
            this.onConfigurationChanged();
        }
    }

    @Override
    public final boolean isConfigured(boolean throwException) throws ComponentValidationException, UnconfiguredConfiguredPropertyException {
        for (ConfiguredPropertyDescriptor configuredProperty : this._descriptor.getConfiguredProperties()) {
            if (this.isConfigured(configuredProperty, throwException)) continue;
            if (throwException) {
                throw new UnconfiguredConfiguredPropertyException(this, configuredProperty);
            }
            return false;
        }
        try {
            LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(this._analysisJobBuilder.getConfiguration(), null, false);
            lifeCycleHelper.validate((ComponentDescriptor<?>)this.getDescriptor(), this.getComponentInstance());
        }
        catch (RuntimeException e) {
            if (throwException) {
                throw e;
            }
            return false;
        }
        return true;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public boolean isConfigured() {
        return this.isConfigured(false);
    }

    @Override
    public boolean isDistributable() {
        if (this.getDescriptor().isDistributable()) {
            Component component = this.getComponentInstanceForQuestioning();
            if (component instanceof HasDistributionAdvice) {
                return ((HasDistributionAdvice)component).isDistributable();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isConfigured(ConfiguredPropertyDescriptor configuredProperty, boolean throwException) throws UnconfiguredConfiguredPropertyException {
        if (configuredProperty.isRequired()) {
            Map<ConfiguredPropertyDescriptor, Object> configuredProperties = this.getConfiguredProperties();
            Object value = configuredProperties.get(configuredProperty);
            if (configuredProperty.isArray() && value != null && Array.getLength(value) == 0) {
                value = null;
            }
            if (value == null) {
                if (throwException) {
                    throw new UnconfiguredConfiguredPropertyException(this, configuredProperty);
                }
                logger.debug("Configured property is not set: " + configuredProperty);
                return false;
            }
        }
        return true;
    }

    public B setConfiguredProperty(String configuredName, Object value) {
        ConfiguredPropertyDescriptor configuredProperty = this._descriptor.getConfiguredProperty(configuredName);
        if (configuredProperty == null) {
            throw new IllegalArgumentException("No such configured property: " + configuredName);
        }
        return this.setConfiguredProperty(configuredProperty, value);
    }

    public B setConfiguredProperty(ConfiguredPropertyDescriptor configuredProperty, Object value) {
        boolean changed = this.setConfiguredPropertyIfChanged(configuredProperty, value);
        if (changed) {
            if (configuredProperty.isInputColumn()) {
                this.registerListenerIfLinkedToTransformer(configuredProperty, value);
            }
            this.onConfigurationChanged();
        }
        return (B)this;
    }

    protected void registerListenerIfLinkedToTransformer(ConfiguredPropertyDescriptor configuredProperty, Object value) {
        this.getTransformedInputColumns(value).forEach(transformedInputColumn -> this.getAnalysisJobBuilder().getTransformerComponentBuilders().stream().filter(transformer -> this.isProvidingColumn((TransformedInputColumn<?>)transformedInputColumn, (TransformerComponentBuilder<?>)transformer)).forEach(transformer -> transformer.addChangeListener(new ComponentBuilderTransformerChangeListener(this, configuredProperty))));
    }

    protected boolean isProvidingColumn(TransformedInputColumn<?> transformedInputColumn, TransformerComponentBuilder<?> transformer) {
        for (MutableInputColumn<?> outputColumn : transformer.getOutputColumns()) {
            if (!outputColumn.equals(transformedInputColumn)) continue;
            return true;
        }
        return false;
    }

    private List<TransformedInputColumn<?>> getTransformedInputColumns(Object value) {
        ArrayList transformedInputColumns = new ArrayList();
        if (value != null) {
            if (value.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Object valuePart = Array.get(value, i);
                    if (valuePart == null || !ReflectionUtils.is(valuePart.getClass(), TransformedInputColumn.class)) continue;
                    transformedInputColumns.add((TransformedInputColumn)valuePart);
                }
            } else if (ReflectionUtils.is(value.getClass(), TransformedInputColumn.class)) {
                transformedInputColumns.add((TransformedInputColumn)value);
            }
        }
        return transformedInputColumns;
    }

    protected boolean setConfiguredPropertyIfChanged(ConfiguredPropertyDescriptor configuredProperty, Object value) {
        if (configuredProperty == null) {
            throw new IllegalArgumentException("configuredProperty cannot be null");
        }
        Object currentValue = configuredProperty.getValue(this._configurableBean);
        if (EqualsBuilder.equals((Object)currentValue, (Object)value)) {
            return false;
        }
        if (value != null) {
            boolean correctType = true;
            if (configuredProperty.isArray()) {
                if (value.getClass().isArray()) {
                    int length = Array.getLength(value);
                    for (int i = 0; i < length; ++i) {
                        Object valuePart = Array.get(value, i);
                        if (valuePart == null) {
                            logger.warn("Element no. {} in array (size {}) is null! Value passed to {}", new Object[]{i, length, configuredProperty});
                            continue;
                        }
                        if (ReflectionUtils.is(valuePart.getClass(), configuredProperty.getBaseType())) continue;
                        correctType = false;
                    }
                } else if (!ReflectionUtils.is(value.getClass(), configuredProperty.getBaseType())) {
                    correctType = false;
                }
            } else if (!ReflectionUtils.is(value.getClass(), configuredProperty.getBaseType())) {
                correctType = false;
            }
            if (!correctType) {
                throw new IllegalArgumentException("Invalid value type: " + value.getClass().getName() + ", expected: " + configuredProperty.getBaseType().getName());
            }
        }
        this.synchronizeDependentProperties(configuredProperty, value, currentValue);
        configuredProperty.setValue(this._configurableBean, value);
        return true;
    }

    private void synchronizeDependentProperties(ConfiguredPropertyDescriptor property, Object newValue, Object currentValue) {
        if (currentValue != null) {
            this.getDescriptor().getConfiguredPropertiesByAnnotation(MappedProperty.class).stream().filter(dependentProperty -> property.getName().equals(((MappedProperty)dependentProperty.getAnnotation(MappedProperty.class)).value())).forEach(dependentProperty -> {
                Object dependentValue = dependentProperty.getValue(this._configurableBean);
                if (dependentValue != null) {
                    HashMap<String, Object> originalMappings = new HashMap<String, Object>();
                    ArrayList synchronizedDependents = new ArrayList();
                    if (currentValue.getClass().isArray()) {
                        int i;
                        for (i = 0; i < Array.getLength(currentValue); ++i) {
                            originalMappings.put(AbstractComponentBuilder.getKey(Array.get(currentValue, i)), Array.get(dependentValue, i));
                        }
                        for (i = 0; i < Array.getLength(newValue); ++i) {
                            synchronizedDependents.add(originalMappings.get(AbstractComponentBuilder.getKey(Array.get(newValue, i))));
                        }
                        dependentProperty.setValue(this._configurableBean, AbstractComponentBuilder.getArray(dependentProperty.getBaseType(), synchronizedDependents));
                    } else if (newValue == null) {
                        dependentProperty.setValue(this._configurableBean, null);
                    }
                }
            });
        }
    }

    private static String getKey(Object object) {
        InputColumn inputColumn;
        if (object instanceof InputColumn && (inputColumn = (InputColumn)object).isVirtualColumn()) {
            return inputColumn.getName();
        }
        return String.valueOf(object.hashCode());
    }

    private static <E> E[] getArray(Class<E> clazz, List<?> baseList) {
        Object[] result = (Object[])Array.newInstance(clazz, baseList.size());
        for (int i = 0; i < baseList.size(); ++i) {
            Array.set(result, i, baseList.get(i));
        }
        return result;
    }

    @Override
    public Map<ConfiguredPropertyDescriptor, Object> getConfiguredProperties() {
        HashMap<ConfiguredPropertyDescriptor, Object> map = new HashMap<ConfiguredPropertyDescriptor, Object>();
        Set configuredProperties = this.getDescriptor().getConfiguredProperties();
        for (ConfiguredPropertyDescriptor propertyDescriptor : configuredProperties) {
            Object value = this.getConfiguredProperty(propertyDescriptor);
            if (value == null) continue;
            map.put(propertyDescriptor, value);
        }
        return Collections.unmodifiableMap(map);
    }

    public void onRequirementChanged() {
    }

    public void onConfigurationChanged() {
    }

    @Override
    public Object getConfiguredProperty(ConfiguredPropertyDescriptor propertyDescriptor) {
        return propertyDescriptor.getValue(this.getConfigurableBean());
    }

    @Override
    public void clearInputColumns() {
        Set configuredProperties = this.getDescriptor().getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor configuredProperty : configuredProperties) {
            if (configuredProperty.isArray()) {
                this.setConfiguredProperty(configuredProperty, (Object)new InputColumn[0]);
                continue;
            }
            this.setConfiguredProperty(configuredProperty, null);
        }
    }

    public B addInputColumn(InputColumn<?> inputColumn) throws IllegalArgumentException {
        ConfiguredPropertyDescriptor propertyDescriptor = this.getDefaultConfiguredPropertyForInput();
        return this.addInputColumn(inputColumn, propertyDescriptor);
    }

    @Override
    public ConfiguredPropertyDescriptor getDefaultConfiguredPropertyForInput() throws UnsupportedOperationException {
        Set inputProperties = this.getDescriptor().getConfiguredPropertiesForInput(false);
        if (inputProperties.isEmpty()) {
            inputProperties = this.getDescriptor().getConfiguredPropertiesForInput(true);
        }
        if (inputProperties.size() == 1) {
            ConfiguredPropertyDescriptor propertyDescriptor = (ConfiguredPropertyDescriptor)inputProperties.iterator().next();
            return propertyDescriptor;
        }
        throw new UnsupportedOperationException("There are " + inputProperties.size() + " named input columns in \"" + this.getDescriptor().getDisplayName() + "\", please specify which one to configure");
    }

    public B addInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) throws IllegalArgumentException {
        Class actualDataType;
        if (propertyDescriptor == null || !propertyDescriptor.isInputColumn()) {
            throw new IllegalArgumentException("Property is not of InputColumn type: " + propertyDescriptor);
        }
        Class expectedDataType = propertyDescriptor.getTypeArgument(0);
        if (expectedDataType != null && expectedDataType != Object.class && !ReflectionUtils.is(actualDataType = inputColumn.getDataType(), expectedDataType, false)) {
            throw new IllegalArgumentException("Unsupported InputColumn type: " + actualDataType + ", expected: " + expectedDataType);
        }
        InputColumn[] inputColumns = this.getConfiguredProperty(propertyDescriptor);
        inputColumns = inputColumns == null ? (propertyDescriptor.isArray() ? new InputColumn[]{inputColumn} : inputColumn) : CollectionUtils2.array(InputColumn.class, inputColumns, new InputColumn[]{inputColumn});
        this.setConfiguredProperty(propertyDescriptor, (Object)inputColumns);
        return (B)this;
    }

    public B addInputColumns(Collection<? extends InputColumn<?>> inputColumns, ConfiguredPropertyDescriptor propertyDescriptor) {
        InputColumn<?> asArray;
        InputColumn<?> newInputColumns;
        if (propertyDescriptor == null || !propertyDescriptor.isInputColumn()) {
            throw new IllegalArgumentException("Property is not of InputColumn type: " + propertyDescriptor);
        }
        Class expectedDataType = propertyDescriptor.getTypeArgument(0);
        if (expectedDataType != null && expectedDataType != Object.class) {
            for (InputColumn<?> inputColumn : inputColumns) {
                Class actualDataType = inputColumn.getDataType();
                if (ReflectionUtils.is(actualDataType, expectedDataType, false)) continue;
                throw new IllegalArgumentException("Unsupported InputColumn type: " + actualDataType + ", expected: " + expectedDataType);
            }
        }
        if ((newInputColumns = this.getConfiguredProperty(propertyDescriptor)) == null) {
            if (propertyDescriptor.isArray()) {
                newInputColumns = asArray = inputColumns.toArray(new InputColumn[inputColumns.size()]);
            } else if (inputColumns == null || inputColumns.isEmpty()) {
                newInputColumns = null;
            } else {
                if (inputColumns.size() > 1) {
                    throw new IllegalArgumentException("Property type is a single InputColumn, but a collection of more than one element was given");
                }
                newInputColumns = inputColumns.iterator().next();
            }
        } else {
            asArray = inputColumns.toArray(new InputColumn[inputColumns.size()]);
            newInputColumns = CollectionUtils2.array(InputColumn.class, newInputColumns, asArray);
        }
        this.setConfiguredProperty(propertyDescriptor, (Object)newInputColumns);
        return (B)this;
    }

    public B addInputColumns(Collection<? extends InputColumn<?>> inputColumns) {
        ConfiguredPropertyDescriptor propertyDescriptor = this.getDefaultConfiguredPropertyForInput();
        this.addInputColumns(inputColumns, propertyDescriptor);
        return (B)this;
    }

    public B addInputColumns(InputColumn<?> ... inputColumns) {
        List<InputColumn<?>> list = Arrays.asList(inputColumns);
        ConfiguredPropertyDescriptor propertyDescriptor = this.getDefaultConfiguredPropertyForInput();
        this.addInputColumns(list, propertyDescriptor);
        return (B)this;
    }

    public B removeInputColumn(InputColumn<?> inputColumn) {
        Set propertyDescriptors = this.getDescriptor().getConfiguredPropertiesForInput();
        if (propertyDescriptors.size() == 1) {
            ConfiguredPropertyDescriptor propertyDescriptor = (ConfiguredPropertyDescriptor)propertyDescriptors.iterator().next();
            return this.removeInputColumn(inputColumn, propertyDescriptor);
        }
        throw new UnsupportedOperationException("There are " + propertyDescriptors.size() + " named input columns, please specify which one to configure");
    }

    public B removeInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) {
        Object inputColumns = this.getConfiguredProperty(propertyDescriptor);
        if (inputColumns != null) {
            if (inputColumns == inputColumn) {
                inputColumns = null;
            } else if (inputColumns.getClass().isArray()) {
                inputColumns = CollectionUtils.arrayRemove((Object)inputColumns, inputColumn);
                if (!propertyDescriptor.isArray() && Array.getLength(inputColumns) == 0) {
                    inputColumns = null;
                }
            }
            this.setConfiguredProperty(propertyDescriptor, inputColumns);
            propertyDescriptor.setValue(this.getComponentInstance(), inputColumns);
        }
        return (B)this;
    }

    public void setRequirement(FilterComponentBuilder<?, ?> filterComponentBuilder, String category) {
        if (filterComponentBuilder == this) {
            throw new IllegalArgumentException("Requirement source and sink cannot be the same");
        }
        FilterOutcome filterOutcome = filterComponentBuilder.getFilterOutcome(category);
        if (filterOutcome == null) {
            throw new IllegalArgumentException("No such category found in available outcomes: " + category);
        }
        this.setRequirement(filterOutcome);
    }

    public void setRequirement(FilterComponentBuilder<?, ?> filterComponentBuilder, Enum<?> category) {
        if (filterComponentBuilder == this) {
            throw new IllegalArgumentException("Requirement source and sink cannot be the same");
        }
        EnumSet categories = ((FilterDescriptor)filterComponentBuilder.getDescriptor()).getOutcomeCategories();
        if (!categories.contains(category)) {
            throw new IllegalArgumentException("No such category found in available outcomes: " + category);
        }
        this.setRequirement(filterComponentBuilder.getFilterOutcome(category));
    }

    public void setRequirement(FilterOutcome outcome) throws IllegalArgumentException {
        if (!this.validateRequirementCandidate(outcome)) {
            throw new IllegalArgumentException("Cyclic dependency detected when setting requirement: " + outcome);
        }
        if (outcome == null) {
            this.setComponentRequirement(null);
        } else if (outcome instanceof FilterOutcome) {
            this.setComponentRequirement(new SimpleComponentRequirement(outcome));
        } else {
            throw new IllegalArgumentException("Unsupported outcome type (use ComponentRequirement instead): " + outcome);
        }
    }

    @Override
    public void setComponentRequirement(ComponentRequirement requirement) {
        if (!EqualsBuilder.equals((Object)this._componentRequirement, (Object)requirement)) {
            this._componentRequirement = requirement;
            this.onRequirementChanged();
        }
    }

    public boolean validateRequirementSource(HasFilterOutcomes outcomeSource) {
        if (outcomeSource == null) {
            return true;
        }
        Collection outcomes = outcomeSource.getFilterOutcomes();
        if (outcomes == null || outcomes.isEmpty()) {
            return true;
        }
        FilterOutcome firstOutcome = (FilterOutcome)outcomes.iterator().next();
        return this.validateRequirementCandidate(firstOutcome);
    }

    public boolean validateRequirementCandidate(ComponentRequirement requirement) {
        if (requirement instanceof SimpleComponentRequirement) {
            SimpleComponentRequirement simpleComponentRequirement = (SimpleComponentRequirement)requirement;
            FilterOutcome outcome = simpleComponentRequirement.getOutcome();
            return this.validateRequirementCandidate(outcome);
        }
        return true;
    }

    public boolean validateRequirementCandidate(FilterOutcome requirement) {
        ComponentRequirement componentRequirement;
        if (requirement == null) {
            return true;
        }
        HasFilterOutcomes source = requirement.getSource();
        if (source == this) {
            return false;
        }
        if (source instanceof HasComponentRequirement && (componentRequirement = ((HasComponentRequirement)source).getComponentRequirement()) != null) {
            Collection requirements = componentRequirement.getProcessingDependencies();
            for (FilterOutcome transitiveRequirement : requirements) {
                boolean transitiveValidation = this.validateRequirementCandidate(transitiveRequirement);
                if (transitiveValidation) continue;
                return false;
            }
        }
        return true;
    }

    public List<InputColumn<?>> getInputColumns() {
        LinkedList<InputColumn> result = new LinkedList<InputColumn>();
        Set configuredPropertiesForInput = this.getDescriptor().getConfiguredPropertiesForInput();
        for (ConfiguredPropertyDescriptor configuredProperty : configuredPropertiesForInput) {
            Object inputColumns = this.getConfiguredProperty(configuredProperty);
            if (inputColumns == null) continue;
            if (inputColumns.getClass().isArray()) {
                int length = Array.getLength(inputColumns);
                for (int i = 0; i < length; ++i) {
                    InputColumn column = (InputColumn)Array.get(inputColumns, i);
                    if (column == null) {
                        logger.warn("Element no. {} in array (size {}) is null! Value read from {}", new Object[]{i, length, configuredProperty});
                        continue;
                    }
                    result.add(column);
                }
                continue;
            }
            result.add((InputColumn)inputColumns);
        }
        return Collections.unmodifiableList(result);
    }

    public ComponentRequirement getComponentRequirement() {
        return this._componentRequirement;
    }

    public InputColumn<?>[] getInput() {
        List<InputColumn<?>> inputColumns = this.getInputColumns();
        return inputColumns.toArray(new InputColumn[inputColumns.size()]);
    }

    protected final void onRemoved() {
        this.onRemovedInternal();
        for (ComponentRemovalListener<ComponentBuilder> removalListener : this._removalListeners) {
            removalListener.onRemove(this);
        }
    }

    protected abstract void onRemovedInternal();

    @Override
    public void addRemovalListener(ComponentRemovalListener<ComponentBuilder> componentRemovalListener) {
        this._removalListeners.add(componentRemovalListener);
    }

    @Override
    public boolean removeRemovalListener(ComponentRemovalListener<ComponentBuilder> componentRemovalListener) {
        return this._removalListeners.remove(componentRemovalListener);
    }

    protected Component getComponentInstanceForQuestioning() {
        if (!this.isConfigured()) {
            return null;
        }
        E component = this.getComponentInstance();
        D descriptor = this.getDescriptor();
        DataCleanerConfiguration configuration = this.getAnalysisJobBuilder().getConfiguration();
        InjectionManager injectionManager = configuration.getEnvironment().getInjectionManagerFactory().getInjectionManager(configuration);
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, false);
        ImmutableComponentConfiguration beanConfiguration = new ImmutableComponentConfiguration(this.getConfiguredPropertiesForQuestioning());
        lifeCycleHelper.assignConfiguredProperties((ComponentDescriptor<?>)descriptor, component, beanConfiguration);
        lifeCycleHelper.assignProvidedProperties((ComponentDescriptor<?>)descriptor, component);
        try {
            lifeCycleHelper.validate((ComponentDescriptor<?>)descriptor, component);
        }
        catch (RuntimeException e) {
            return null;
        }
        return component;
    }

    protected Map<ConfiguredPropertyDescriptor, Object> getConfiguredPropertiesForQuestioning() {
        return this.getConfiguredProperties();
    }

    @Override
    public AnalysisJobBuilder getOutputDataStreamJobBuilder(String outputDataStreamName) {
        OutputDataStream outputDataStream = this.getOutputDataStream(outputDataStreamName);
        if (outputDataStream == null) {
            throw new IllegalArgumentException("No such OutputDataStream: " + outputDataStreamName);
        }
        return this.getOutputDataStreamJobBuilder(outputDataStream);
    }

    @Override
    public AnalysisJobBuilder getOutputDataStreamJobBuilder(OutputDataStream outputDataStream) {
        AnalysisJobBuilder analysisJobBuilder = this._outputDataStreamJobs.get(outputDataStream);
        if (analysisJobBuilder == null) {
            assert (this._outputDataStreams.contains(outputDataStream));
            Table table = outputDataStream.getTable();
            analysisJobBuilder = new AnalysisJobBuilder(this._analysisJobBuilder.getConfiguration(), this._analysisJobBuilder);
            analysisJobBuilder.setDatastore(new OutputDataStreamDatastore(outputDataStream));
            analysisJobBuilder.addSourceColumns(table.getColumns());
            this._outputDataStreamJobs.put(outputDataStream, analysisJobBuilder);
        }
        return analysisJobBuilder;
    }

    @Override
    public OutputDataStream getOutputDataStream(Table dataStreamTable) {
        if (dataStreamTable == null) {
            return null;
        }
        List<OutputDataStream> streams = this.getOutputDataStreams();
        for (OutputDataStream outputDataStream : streams) {
            if (!dataStreamTable.equals(outputDataStream.getTable())) continue;
            return outputDataStream;
        }
        return null;
    }

    @Override
    public OutputDataStream getOutputDataStream(String name) {
        if (name == null) {
            return null;
        }
        List<OutputDataStream> streams = this.getOutputDataStreams();
        for (OutputDataStream outputDataStream : streams) {
            if (!name.equals(outputDataStream.getName())) continue;
            return outputDataStream;
        }
        return null;
    }

    @Override
    public List<OutputDataStream> getOutputDataStreams() {
        Component component = this.getComponentInstanceForQuestioning();
        if (component == null) {
            return Collections.emptyList();
        }
        if (component instanceof HasOutputDataStreams) {
            OutputDataStream[] outputDataStreams = ((HasOutputDataStreams)component).getOutputDataStreams();
            List<OutputDataStream> newStreams = Arrays.asList(outputDataStreams);
            if (!this._outputDataStreams.equals(newStreams)) {
                List existingNames;
                List newNames = CollectionUtils.map(newStreams, (Func)new HasNameMapper());
                if (!newNames.equals(existingNames = CollectionUtils.map(this._outputDataStreams, (Func)new HasNameMapper()))) {
                    this._outputDataStreams.clear();
                    this._outputDataStreamJobs.clear();
                    this._outputDataStreams.addAll(newStreams);
                } else {
                    for (int i = 0; i < outputDataStreams.length; ++i) {
                        OutputDataStream existingStream = this._outputDataStreams.get(i);
                        Table table = existingStream.getTable();
                        OutputDataStream newStream = newStreams.get(i);
                        if (table instanceof MutableTable) {
                            MutableTable mutableTable = (MutableTable)table;
                            if (this.isOutputDataStreamConsumed(existingStream)) {
                                AnalysisJobBuilder existingJobBuilder = this.getOutputDataStreamJobBuilder(existingStream);
                                this.updateStream(mutableTable, existingJobBuilder, newStream);
                                continue;
                            }
                            this.updateStream(mutableTable, null, newStream);
                            continue;
                        }
                        this._outputDataStreams.set(i, newStream);
                    }
                }
            }
            return new ArrayList<OutputDataStream>(this._outputDataStreams);
        }
        return Collections.emptyList();
    }

    private void updateStream(MutableTable existingTable, AnalysisJobBuilder jobBuilder, OutputDataStream newStream) {
        ArrayList<MutableColumn> newColumnList = new ArrayList<MutableColumn>();
        ArrayList<Column> addedColumns = new ArrayList<Column>();
        Table newTable = newStream.getTable();
        int columnNumber = 0;
        for (Column newColumn : newTable.getColumns()) {
            MutableColumn mutableColumn;
            Column existingColumn = existingTable.getColumnByName(newColumn.getName());
            if (existingColumn == null) {
                mutableColumn = (MutableColumn)newColumn;
                addedColumns.add(newColumn);
            } else {
                mutableColumn = (MutableColumn)existingColumn;
                existingTable.removeColumn(existingColumn);
            }
            mutableColumn.setTable((Table)existingTable);
            mutableColumn.setColumnNumber(columnNumber);
            mutableColumn.setType(newColumn.getType());
            newColumnList.add(mutableColumn);
            ++columnNumber;
        }
        if (jobBuilder != null) {
            for (Column column : existingTable.getColumns()) {
                jobBuilder.removeSourceColumn(column);
            }
            for (Column column : addedColumns) {
                jobBuilder.addSourceColumn(column);
            }
        }
        existingTable.setColumns(newColumnList);
    }

    @Override
    public boolean isOutputDataStreamConsumed(OutputDataStream outputDataStream) {
        AnalysisJobBuilder analysisJobBuilder = this._outputDataStreamJobs.get(outputDataStream);
        if (analysisJobBuilder == null) {
            return false;
        }
        return analysisJobBuilder.getComponentCount() > 0;
    }

    public OutputDataStreamJob[] getOutputDataStreamJobs() {
        List<OutputDataStream> outputDataStreams = this.getOutputDataStreams();
        if (outputDataStreams == null || outputDataStreams.isEmpty()) {
            return new OutputDataStreamJob[0];
        }
        ArrayList<LazyOutputDataStreamJob> result = new ArrayList<LazyOutputDataStreamJob>();
        for (OutputDataStream outputDataStream : outputDataStreams) {
            if (!this.isOutputDataStreamConsumed(outputDataStream)) continue;
            result.add(new LazyOutputDataStreamJob(outputDataStream, this.getOutputDataStreamJobBuilder(outputDataStream)));
        }
        return result.toArray(new OutputDataStreamJob[result.size()]);
    }

    @Override
    public void setAnalysisJobBuilder(AnalysisJobBuilder analysisJobBuilder) {
        this._analysisJobBuilder = analysisJobBuilder;
    }
}

