/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.ColumnProperty;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.descriptors.AnalyzerDescriptor;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.AnalysisJobImmutabilizer;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentConfiguration;
import org.datacleaner.job.ComponentConfigurationException;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.ImmutableAnalyzerJob;
import org.datacleaner.job.ImmutableComponentConfiguration;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.job.builder.AbstractComponentBuilder;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.AnalyzerChangeListener;
import org.datacleaner.util.LabelUtils;
import org.datacleaner.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalyzerComponentBuilder<A extends Analyzer<?>>
extends AbstractComponentBuilder<AnalyzerDescriptor<A>, A, AnalyzerComponentBuilder<A>> {
    public static final String METADATA_PROPERTY_BUILDER_ID = "org.datacleaner.componentbuilder.id";
    public static final String METADATA_PROPERTY_BUILDER_PARTITION_INDEX = "org.datacleaner.componentbuilder.partition.index";
    private static final Logger logger = LoggerFactory.getLogger(AnalysisJobBuilder.class);
    private final boolean _multipleJobsSupported;
    private final List<InputColumn<?>> _escalatingInputColumns;
    private final ConfiguredPropertyDescriptor _escalatingInputProperty;
    private final List<AnalyzerChangeListener> _localChangeListeners;

    public AnalyzerComponentBuilder(AnalysisJobBuilder analysisJobBuilder, AnalyzerDescriptor<A> descriptor) {
        super(analysisJobBuilder, descriptor, AnalyzerComponentBuilder.class);
        Set requiredInputProperties = descriptor.getConfiguredPropertiesForInput(false);
        if (requiredInputProperties.size() == 1) {
            this._escalatingInputProperty = (ConfiguredPropertyDescriptor)requiredInputProperties.iterator().next();
            ColumnProperty columnProperty = (ColumnProperty)this._escalatingInputProperty.getAnnotation(ColumnProperty.class);
            this._multipleJobsSupported = columnProperty != null && !this._escalatingInputProperty.isArray() && columnProperty.escalateToMultipleJobs();
            this._escalatingInputColumns = new ArrayList();
        } else {
            this._multipleJobsSupported = false;
            this._escalatingInputProperty = null;
            this._escalatingInputColumns = Collections.emptyList();
        }
        this._localChangeListeners = new ArrayList<AnalyzerChangeListener>(0);
    }

    private List<AnalyzerChangeListener> getAllListeners() {
        List<AnalyzerChangeListener> globalChangeListeners = this.getAnalysisJobBuilder().getAnalyzerChangeListeners();
        ArrayList<AnalyzerChangeListener> list = new ArrayList<AnalyzerChangeListener>(globalChangeListeners.size() + this._localChangeListeners.size());
        list.addAll(globalChangeListeners);
        list.addAll(this._localChangeListeners);
        return list;
    }

    public boolean isMultipleJobsDeterminedBy(ConfiguredPropertyDescriptor propertyDescriptor) {
        return this._multipleJobsSupported && !propertyDescriptor.isArray() && propertyDescriptor.isInputColumn() && propertyDescriptor.isRequired();
    }

    public AnalyzerJob toAnalyzerJob() throws IllegalStateException {
        return this.toAnalyzerJob(true);
    }

    public AnalyzerJob toAnalyzerJob(boolean validate) throws IllegalStateException {
        AnalyzerJob[] analyzerJobs = this.toAnalyzerJobs(validate);
        if (analyzerJobs == null || analyzerJobs.length == 0) {
            return null;
        }
        if (validate && analyzerJobs.length > 1) {
            throw new IllegalStateException("This builder generates " + analyzerJobs.length + " jobs, but a single job was requested");
        }
        return analyzerJobs[0];
    }

    public AnalyzerJob[] toAnalyzerJobs() throws IllegalStateException {
        return this.toAnalyzerJobs(true);
    }

    public AnalyzerJob[] toAnalyzerJobs(AnalysisJobImmutabilizer immutabilizer) throws IllegalStateException {
        return this.toAnalyzerJobs(true, immutabilizer);
    }

    public AnalyzerJob[] toAnalyzerJobs(boolean validate) throws IllegalStateException {
        return this.toAnalyzerJobs(validate, new AnalysisJobImmutabilizer());
    }

    public AnalyzerJob[] toAnalyzerJobs(boolean validate, AnalysisJobImmutabilizer immutabilizer) throws IllegalStateException {
        Map<ConfiguredPropertyDescriptor, Object> configuredProperties = this.getConfiguredProperties();
        ComponentRequirement componentRequirement = immutabilizer.load(this.getComponentRequirement());
        List<InputColumn<?>> inputColumns = this._escalatingInputProperty != null && !this._escalatingInputColumns.isEmpty() ? this._escalatingInputColumns : this.getInputColumns();
        if (validate && inputColumns.isEmpty()) {
            throw new IllegalStateException("No input column(s) configured");
        }
        ArrayList tableLessColumns = new ArrayList();
        LinkedHashMap originatingTables = new LinkedHashMap();
        for (InputColumn<?> inputColumn : inputColumns) {
            Table table = this.getAnalysisJobBuilder().getOriginatingTable(inputColumn);
            if (table == null) {
                tableLessColumns.add(inputColumn);
                continue;
            }
            ArrayList list = (ArrayList)originatingTables.get(table);
            if (list == null) {
                list = new ArrayList();
            }
            list.add(inputColumn);
            originatingTables.put(table, list);
        }
        if (validate && originatingTables.isEmpty()) {
            List<Table> sourceTables = this.getAnalysisJobBuilder().getSourceTables();
            if (sourceTables.size() == 1) {
                logger.info("Only a single source table is available, so the source of analyzer '{}' is inferred", (Object)this);
                Table table = sourceTables.get(0);
                originatingTables.put(table, new ArrayList());
            } else {
                throw new IllegalStateException("Could not determine source for analyzer '" + this + "'");
            }
        }
        if (!this.isMultipleJobsSupported() && originatingTables.size() == 1) {
            OutputDataStreamJob[] outputDataStreamJobs = immutabilizer.load(this.getOutputDataStreamJobs(), validate);
            ImmutableAnalyzerJob job = new ImmutableAnalyzerJob(this.getName(), (AnalyzerDescriptor)this.getDescriptor(), (ComponentConfiguration)new ImmutableComponentConfiguration(configuredProperties), componentRequirement, this.getMetadataProperties(), outputDataStreamJobs);
            return new AnalyzerJob[]{job};
        }
        for (Map.Entry entry : originatingTables.entrySet()) {
            ((List)entry.getValue()).addAll(tableLessColumns);
        }
        ArrayList<AnalyzerJob> jobs = new ArrayList<AnalyzerJob>();
        Set entrySet = originatingTables.entrySet();
        int partitionIndex = 0;
        for (Map.Entry entry : entrySet) {
            List columnsOfTable = (List)entry.getValue();
            if (this._escalatingInputProperty == null || this._escalatingInputProperty.isArray()) {
                jobs.add(this.createPartitionedJob(null, columnsOfTable, configuredProperties, partitionIndex++));
                continue;
            }
            for (InputColumn escalatingColumn : columnsOfTable) {
                jobs.add(this.createPartitionedJob(escalatingColumn, columnsOfTable, configuredProperties, partitionIndex++));
            }
        }
        if (validate && !this.isConfigured()) {
            throw new IllegalStateException("Row processing Analyzer job is not correctly configured");
        }
        return jobs.toArray(new AnalyzerJob[jobs.size()]);
    }

    @Override
    public AnalyzerComponentBuilder<A> addInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) {
        assert (propertyDescriptor.isInputColumn());
        if (inputColumn == null) {
            throw new IllegalArgumentException("InputColumn cannot be null");
        }
        if (this.isMultipleJobsDeterminedBy(propertyDescriptor)) {
            this._escalatingInputColumns.add(inputColumn);
            this.registerListenerIfLinkedToTransformer(propertyDescriptor, this._escalatingInputColumns.toArray(new InputColumn[this._escalatingInputColumns.size()]));
            return this;
        }
        return (AnalyzerComponentBuilder)super.addInputColumn(inputColumn, propertyDescriptor);
    }

    @Override
    public AnalyzerComponentBuilder<A> removeInputColumn(InputColumn<?> inputColumn, ConfiguredPropertyDescriptor propertyDescriptor) {
        assert (propertyDescriptor.isInputColumn());
        if (inputColumn == null) {
            throw new IllegalArgumentException("InputColumn cannot be null");
        }
        if (this.isMultipleJobsDeterminedBy(propertyDescriptor)) {
            this._escalatingInputColumns.remove(inputColumn);
            return this;
        }
        return (AnalyzerComponentBuilder)super.removeInputColumn(inputColumn, propertyDescriptor);
    }

    @Override
    public boolean isConfigured(ConfiguredPropertyDescriptor configuredProperty, boolean throwException) {
        if (this.isMultipleJobsSupported() && configuredProperty == this._escalatingInputProperty) {
            if (this._escalatingInputColumns.isEmpty()) {
                Object propertyValue = super.getConfiguredProperty(configuredProperty);
                if (propertyValue != null && propertyValue.getClass().isArray() && Array.getLength(propertyValue) > 0) {
                    this.setConfiguredProperty(configuredProperty, propertyValue);
                    return this.isConfigured(configuredProperty, throwException);
                }
                if (throwException) {
                    throw new ComponentConfigurationException("No input columns configured for " + LabelUtils.getLabel(this));
                }
                return false;
            }
            return true;
        }
        return super.isConfigured(configuredProperty, throwException);
    }

    private AnalyzerJob createPartitionedJob(InputColumn<?> escalatingColumnValue, Collection<InputColumn<?>> availableColumns, Map<ConfiguredPropertyDescriptor, Object> configuredProperties, int partitionIndex) {
        HashMap<ConfiguredPropertyDescriptor, Object> jobProperties = new HashMap<ConfiguredPropertyDescriptor, Object>(configuredProperties);
        for (Map.Entry entry : jobProperties.entrySet()) {
            ConfiguredPropertyDescriptor propertyDescriptor = (ConfiguredPropertyDescriptor)entry.getKey();
            if (!propertyDescriptor.isInputColumn()) continue;
            Object unpartitionedValue = escalatingColumnValue != null && this._escalatingInputProperty == propertyDescriptor ? escalatingColumnValue : entry.getValue();
            Object partitionedValue = this.partitionValue(propertyDescriptor, unpartitionedValue, availableColumns);
            entry.setValue(partitionedValue);
        }
        LinkedHashMap<String, String> metadataProperties = new LinkedHashMap<String, String>(this.getMetadataProperties());
        metadataProperties.put(METADATA_PROPERTY_BUILDER_ID, "" + System.identityHashCode(this));
        metadataProperties.put(METADATA_PROPERTY_BUILDER_PARTITION_INDEX, "" + partitionIndex);
        OutputDataStreamJob[] outputDataStreamJobArray = new OutputDataStreamJob[]{};
        ComponentRequirement componentRequirement = new AnalysisJobImmutabilizer().load(this.getComponentRequirement());
        ImmutableAnalyzerJob job = new ImmutableAnalyzerJob(this.getName(), (AnalyzerDescriptor)this.getDescriptor(), (ComponentConfiguration)new ImmutableComponentConfiguration(jobProperties), componentRequirement, metadataProperties, outputDataStreamJobArray);
        return job;
    }

    private Object partitionValue(ConfiguredPropertyDescriptor key, Object unpartitionedValue, Collection<InputColumn<?>> availableColumns) {
        if (unpartitionedValue instanceof InputColumn[]) {
            InputColumn[] array = (InputColumn[])unpartitionedValue;
            ArrayList<InputColumn> result = new ArrayList<InputColumn>();
            for (InputColumn inputColumn : array) {
                if (!availableColumns.contains(inputColumn)) continue;
                result.add(inputColumn);
            }
            if (!key.isArray()) {
                if (result.isEmpty()) {
                    return null;
                }
                return result.get(0);
            }
            return result.toArray(new InputColumn[result.size()]);
        }
        return unpartitionedValue;
    }

    public String toString() {
        return "AnalyzerComponentBuilder[analyzer=" + ((AnalyzerDescriptor)this.getDescriptor()).getDisplayName() + ",inputColumns=" + this.getInputColumns() + "]";
    }

    @Override
    public AnalyzerComponentBuilder<A> setConfiguredProperty(ConfiguredPropertyDescriptor configuredProperty, Object value) {
        if (this.isMultipleJobsDeterminedBy(configuredProperty)) {
            AnalyzerComponentBuilder componentBuilder;
            Object dummyValue;
            this._escalatingInputColumns.clear();
            if (value == null) {
                dummyValue = null;
            } else if (ReflectionUtils.isArray(value)) {
                int length = Array.getLength(value);
                for (int i = 0; i < length; ++i) {
                    InputColumn inputColumn = (InputColumn)Array.get(value, i);
                    this._escalatingInputColumns.add(inputColumn);
                }
                dummyValue = this._escalatingInputColumns.isEmpty() ? null : this._escalatingInputColumns.iterator().next();
            } else {
                InputColumn<?> col = (InputColumn<?>)value;
                this._escalatingInputColumns.add(col);
                dummyValue = col;
            }
            if (configuredProperty.isArray()) {
                InputColumn[] inputColumsArray = dummyValue == null ? new InputColumn[]{} : new InputColumn[]{dummyValue};
                componentBuilder = (AnalyzerComponentBuilder)super.setConfiguredProperty(configuredProperty, (Object)inputColumsArray);
            } else {
                componentBuilder = (AnalyzerComponentBuilder)super.setConfiguredProperty(configuredProperty, dummyValue);
            }
            this.registerListenerIfLinkedToTransformer(configuredProperty, value);
            return componentBuilder;
        }
        return (AnalyzerComponentBuilder)super.setConfiguredProperty(configuredProperty, value);
    }

    @Override
    public Object getConfiguredProperty(ConfiguredPropertyDescriptor propertyDescriptor) {
        if (this.isMultipleJobsDeterminedBy(propertyDescriptor)) {
            return this._escalatingInputColumns.toArray(new InputColumn[this._escalatingInputColumns.size()]);
        }
        return super.getConfiguredProperty(propertyDescriptor);
    }

    @Override
    public void onConfigurationChanged() {
        super.onConfigurationChanged();
        List<AnalyzerChangeListener> listeners = this.getAllListeners();
        for (AnalyzerChangeListener listener : listeners) {
            listener.onConfigurationChanged(this);
        }
    }

    @Override
    public void onRequirementChanged() {
        super.onRequirementChanged();
        List<AnalyzerChangeListener> listeners = this.getAllListeners();
        for (AnalyzerChangeListener listener : listeners) {
            listener.onRequirementChanged(this);
        }
    }

    public boolean isMultipleJobsSupported() {
        return this._multipleJobsSupported;
    }

    @Override
    public List<OutputDataStream> getOutputDataStreams() {
        if (this.isMultipleJobsSupported()) {
            return Collections.emptyList();
        }
        return super.getOutputDataStreams();
    }

    @Override
    protected Map<ConfiguredPropertyDescriptor, Object> getConfiguredPropertiesForQuestioning() {
        Map<ConfiguredPropertyDescriptor, Object> properties = super.getConfiguredPropertiesForQuestioning();
        if (!this.isMultipleJobsSupported()) {
            return properties;
        }
        HashMap<ConfiguredPropertyDescriptor, Object> map = new HashMap<ConfiguredPropertyDescriptor, Object>(properties);
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            if (!this.isMultipleJobsDeterminedBy((ConfiguredPropertyDescriptor)entry.getKey()) || Array.getLength(value = entry.getValue()) <= 1) continue;
            Object element = Array.get(value, 0);
            entry.setValue(element);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    protected void onRemovedInternal() {
        List<AnalyzerChangeListener> listeners = this.getAllListeners();
        for (AnalyzerChangeListener listener : listeners) {
            listener.onRemove(this);
        }
    }

    public void addChangeListener(AnalyzerChangeListener listener) {
        this._localChangeListeners.add(listener);
    }

    public boolean removeChangeListener(AnalyzerChangeListener listener) {
        return this._localChangeListeners.remove(listener);
    }
}

