/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.util.List;
import java.util.Objects;
import org.datacleaner.api.InputColumn;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.descriptors.ConfiguredPropertyDescriptor;
import org.datacleaner.job.builder.ComponentBuilder;
import org.datacleaner.job.builder.TransformerChangeListener;
import org.datacleaner.job.builder.TransformerComponentBuilder;
import org.datacleaner.util.ReflectionUtils;

public class ComponentBuilderTransformerChangeListener
implements TransformerChangeListener {
    private final ComponentBuilder _componentBuilder;
    private final ConfiguredPropertyDescriptor _propertyDescriptor;

    public ComponentBuilderTransformerChangeListener(ComponentBuilder componentBuilder, ConfiguredPropertyDescriptor propertyDescriptor) {
        this._componentBuilder = componentBuilder;
        this._propertyDescriptor = propertyDescriptor;
    }

    @Override
    public void onAdd(TransformerComponentBuilder<?> builder) {
    }

    @Override
    public void onConfigurationChanged(TransformerComponentBuilder<?> builder) {
        this.synchronizeInputColumns(builder);
    }

    @Override
    public void onRequirementChanged(TransformerComponentBuilder<?> builder) {
    }

    @Override
    public void onRemove(TransformerComponentBuilder<?> componentBuilder) {
        this.synchronizeInputColumns(componentBuilder);
    }

    @Override
    public void onOutputChanged(TransformerComponentBuilder<?> transformerJobBuilder, List<MutableInputColumn<?>> outputColumns) {
        this.synchronizeInputColumns(transformerJobBuilder);
    }

    private void synchronizeInputColumns(TransformerComponentBuilder<?> changedBuilder) {
        if (!changedBuilder.equals(this._componentBuilder)) {
            List<InputColumn<?>> availableColumns = this._componentBuilder.getAnalysisJobBuilder().getAvailableInputColumns(this._componentBuilder, this._propertyDescriptor.getTypeArgument(0));
            for (ConfiguredPropertyDescriptor propertyDescriptor : this._componentBuilder.getDescriptor().getConfiguredPropertiesForInput()) {
                Object configuredProperty = this._componentBuilder.getConfiguredProperty(propertyDescriptor);
                if (configuredProperty == null || !ReflectionUtils.isInputColumn(configuredProperty.getClass())) continue;
                if (ReflectionUtils.isArray(configuredProperty)) {
                    for (InputColumn column : (InputColumn[])configuredProperty) {
                        if (availableColumns.contains(column)) continue;
                        this._componentBuilder.removeInputColumn(column, propertyDescriptor);
                    }
                    continue;
                }
                if (availableColumns.contains(configuredProperty)) continue;
                this._componentBuilder.removeInputColumn((InputColumn)configuredProperty, propertyDescriptor);
            }
        }
    }

    public boolean equals(Object object) {
        return super.equals(object) || object != null && object instanceof ComponentBuilderTransformerChangeListener && ((ComponentBuilderTransformerChangeListener)object)._componentBuilder == this._componentBuilder && ((ComponentBuilderTransformerChangeListener)object)._propertyDescriptor == this._propertyDescriptor;
    }

    public int hashCode() {
        return Objects.hash(this._componentBuilder, this._propertyDescriptor);
    }
}

