/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.builder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.datacleaner.api.Component;
import org.datacleaner.api.HideOutputColumns;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.OutputColumns;
import org.datacleaner.api.Transformer;
import org.datacleaner.configuration.RemoteServerState;
import org.datacleaner.data.MutableInputColumn;
import org.datacleaner.data.TransformedInputColumn;
import org.datacleaner.descriptors.RemoteTransformerDescriptor;
import org.datacleaner.descriptors.TransformerDescriptor;
import org.datacleaner.job.AnalysisJobImmutabilizer;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.IdGenerator;
import org.datacleaner.job.ImmutableComponentConfiguration;
import org.datacleaner.job.ImmutableTransformerJob;
import org.datacleaner.job.InputColumnSinkJob;
import org.datacleaner.job.InputColumnSourceJob;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.builder.AbstractComponentBuilder;
import org.datacleaner.job.builder.AnalysisJobBuilder;
import org.datacleaner.job.builder.TransformerChangeListener;
import org.datacleaner.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransformerComponentBuilder<T extends Transformer>
extends AbstractComponentBuilder<TransformerDescriptor<T>, T, TransformerComponentBuilder<T>>
implements InputColumnSourceJob,
InputColumnSinkJob,
HasComponentRequirement {
    private static final Logger logger = LoggerFactory.getLogger(TransformerComponentBuilder.class);
    private final String _id;
    private final List<MutableInputColumn<?>> _outputColumns = new ArrayList();
    private final List<String> _automaticOutputColumnNames = new ArrayList<String>();
    private final IdGenerator _idGenerator;
    private final List<TransformerChangeListener> _localChangeListeners;

    public TransformerComponentBuilder(AnalysisJobBuilder analysisJobBuilder, TransformerDescriptor<T> descriptor, IdGenerator idGenerator) {
        super(analysisJobBuilder, descriptor, TransformerComponentBuilder.class);
        this._id = "trans-" + idGenerator.nextId();
        this._idGenerator = idGenerator;
        this._localChangeListeners = new ArrayList<TransformerChangeListener>(0);
    }

    public List<MutableInputColumn<?>> getOutputColumns() {
        int existingCols;
        OutputColumns outputColumns;
        RemoteServerState state;
        Component component = this.getComponentInstanceForQuestioning();
        if (component == null) {
            return Collections.emptyList();
        }
        Transformer transformer = (Transformer)component;
        Object componentDescriptor = this.getDescriptor();
        if (componentDescriptor instanceof RemoteTransformerDescriptor && (state = ((RemoteTransformerDescriptor)componentDescriptor).getRemoteDescriptorProvider().getServerState()).getActualState() == RemoteServerState.State.ERROR) {
            logger.warn("Output columns for transformer '" + transformer + "' can not be retrieved because the remote server is down. ");
            return Collections.emptyList();
        }
        try {
            outputColumns = transformer.getOutputColumns();
        }
        catch (Exception e) {
            logger.error("getOutputColumn() threw unexpected exception on transformer: " + transformer, (Throwable)e);
            return Collections.emptyList();
        }
        if (outputColumns == null) {
            logger.error("getOutputColumns() returned null on transformer: " + transformer);
            return Collections.emptyList();
        }
        boolean changed = false;
        int expectedCols = outputColumns.getColumnCount();
        if (expectedCols != (existingCols = this._outputColumns.size())) {
            int i;
            changed = true;
            int colDiff = expectedCols - existingCols;
            if (colDiff > 0) {
                for (i = 0; i < colDiff; ++i) {
                    int nextIndex = this._outputColumns.size();
                    String name = this.getColumnName(outputColumns, nextIndex);
                    String id = this._id + "-" + this._idGenerator.nextId();
                    TransformedInputColumn column = new TransformedInputColumn(name, id);
                    HideOutputColumns hideOutputColumnsAnnotation = (HideOutputColumns)((TransformerDescriptor)this.getDescriptor()).getAnnotation(HideOutputColumns.class);
                    if (hideOutputColumnsAnnotation != null && hideOutputColumnsAnnotation.isHidden()) {
                        column.setHidden(true);
                    }
                    this._outputColumns.add(column);
                    this._automaticOutputColumnNames.add(name);
                }
            } else if (colDiff < 0) {
                for (i = 0; i < Math.abs(colDiff); ++i) {
                    this._outputColumns.remove(this._outputColumns.size() - 1);
                    this._automaticOutputColumnNames.remove(this._automaticOutputColumnNames.size() - 1);
                }
            }
            for (i = 0; i < expectedCols; ++i) {
                MutableInputColumn<?> column = this._outputColumns.get(i);
                String previousProposedName = column.getInitialName();
                String newProposedName = outputColumns.getColumnName(i);
                if (newProposedName == null || newProposedName.equals(previousProposedName)) continue;
                column.setName(newProposedName);
            }
        }
        for (int i = 0; i < expectedCols; ++i) {
            String proposedName = this.getColumnName(outputColumns, i);
            Class dataType = outputColumns.getColumnType(i);
            TransformedInputColumn col = (TransformedInputColumn)this._outputColumns.get(i);
            col.setInitialName(proposedName);
            if (dataType != col.getDataType()) {
                col.setDataType(dataType);
                changed = true;
            }
            String automaticName = this._automaticOutputColumnNames.get(i);
            String columnName = col.getName();
            if (!StringUtils.isNullOrEmpty(columnName) && !automaticName.equals(columnName) || proposedName == null) continue;
            col.setName(proposedName);
            this._automaticOutputColumnNames.set(i, proposedName);
        }
        if (changed) {
            this.onOutputChanged();
        }
        return Collections.unmodifiableList(this._outputColumns);
    }

    private String getColumnName(OutputColumns outputColumns, int index) {
        String name = outputColumns.getColumnName(index);
        if (name == null) {
            name = ((TransformerDescriptor)this.getDescriptor()).getDisplayName() + " (" + (index + 1) + ")";
        }
        return name;
    }

    public void onOutputChanged() {
        List<TransformerChangeListener> listeners = this.getAllListeners();
        for (TransformerChangeListener listener : listeners) {
            listener.onOutputChanged(this, this._outputColumns);
        }
    }

    public TransformerJob toTransformerJob() throws IllegalStateException {
        return this.toTransformerJob(true);
    }

    public TransformerJob toTransformerJob(AnalysisJobImmutabilizer immutabilizer) throws IllegalStateException {
        return this.toTransformerJob(true, immutabilizer);
    }

    public TransformerJob toTransformerJob(boolean validate) {
        return this.toTransformerJob(validate, new AnalysisJobImmutabilizer());
    }

    public TransformerJob toTransformerJob(boolean validate, AnalysisJobImmutabilizer immutabilizer) {
        if (validate && !this.isConfigured(true)) {
            throw new IllegalStateException("Transformer job is not correctly configured");
        }
        ComponentRequirement componentRequirement = immutabilizer.load(this.getComponentRequirement());
        OutputDataStreamJob[] outputDataStreamJobs = immutabilizer.load(this.getOutputDataStreamJobs(), validate);
        return new ImmutableTransformerJob(this.getName(), (TransformerDescriptor)this.getDescriptor(), new ImmutableComponentConfiguration(this.getConfiguredProperties()), this.getOutputColumns(), componentRequirement, this.getMetadataProperties(), outputDataStreamJobs);
    }

    public String toString() {
        return "TransformerComponentBuilder[transformer=" + ((TransformerDescriptor)this.getDescriptor()).getDisplayName() + ",inputColumns=" + this.getInputColumns() + "]";
    }

    private List<TransformerChangeListener> getAllListeners() {
        List<TransformerChangeListener> globalChangeListeners = this.getAnalysisJobBuilder().getTransformerChangeListeners();
        ArrayList<TransformerChangeListener> list = new ArrayList<TransformerChangeListener>(globalChangeListeners.size() + this._localChangeListeners.size());
        list.addAll(globalChangeListeners);
        list.addAll(this._localChangeListeners);
        return list;
    }

    public MutableInputColumn<?> getOutputColumnByName(String name) {
        if (StringUtils.isNullOrEmpty(name)) {
            return null;
        }
        List<MutableInputColumn<?>> outputColumns = this.getOutputColumns();
        for (MutableInputColumn<?> inputColumn : outputColumns) {
            if (!name.equals(inputColumn.getName())) continue;
            return inputColumn;
        }
        return null;
    }

    @Override
    public void onConfigurationChanged() {
        super.onConfigurationChanged();
        if (this.isConfigured()) {
            this.getOutputColumns();
        }
        List<TransformerChangeListener> listeners = this.getAllListeners();
        for (TransformerChangeListener listener : listeners) {
            listener.onConfigurationChanged(this);
        }
    }

    @Override
    public void onRequirementChanged() {
        super.onRequirementChanged();
        List<TransformerChangeListener> listeners = this.getAllListeners();
        for (TransformerChangeListener listener : listeners) {
            listener.onRequirementChanged(this);
        }
    }

    @Override
    public InputColumn<?>[] getInput() {
        return this.getInputColumns().toArray(new InputColumn[0]);
    }

    public MutableInputColumn<?>[] getOutput() {
        return this.getOutputColumns().toArray(new MutableInputColumn[0]);
    }

    @Override
    protected void onRemovedInternal() {
        List<TransformerChangeListener> listeners = this.getAllListeners();
        for (TransformerChangeListener listener : listeners) {
            listener.onOutputChanged(this, new LinkedList());
            listener.onRemove(this);
        }
    }

    public void addChangeListener(TransformerChangeListener listener) {
        if (!this._localChangeListeners.contains(listener)) {
            this._localChangeListeners.add(listener);
        }
    }

    public boolean removeChangeListener(TransformerChangeListener listener) {
        return this._localChangeListeners.remove(listener);
    }
}

