/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.concurrent;

import java.util.Date;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.job.concurrent.StatusAwareTaskListener;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.util.ConcurrencyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobCompletionTaskListener
implements StatusAwareTaskListener {
    private static final Logger logger = LoggerFactory.getLogger(JobCompletionTaskListener.class);
    private final CountDownLatch _countDownLatch;
    private final AtomicInteger _successCountDown;
    private final AnalysisListener _analysisListener;
    private final AnalysisJobMetrics _analysisJobMetrics;
    private Date _completionTime;

    public JobCompletionTaskListener(AnalysisJobMetrics analysisJobMetrics, AnalysisListener analysisListener, int callablesToWaitFor) {
        this._analysisJobMetrics = analysisJobMetrics;
        this._analysisListener = analysisListener;
        this._countDownLatch = new CountDownLatch(callablesToWaitFor);
        this._successCountDown = new AtomicInteger(callablesToWaitFor);
    }

    @Override
    public void await() throws InterruptedException {
        ConcurrencyUtils.awaitCountDown(this._countDownLatch, "job completion");
    }

    @Override
    public boolean isDone() {
        return this._countDownLatch.getCount() == 0L;
    }

    @Override
    public void await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        this._countDownLatch.await(timeout, timeUnit);
    }

    public void onBegin(Task task) {
    }

    public void onComplete(Task task) {
        try {
            logger.debug("onComplete(...)");
            int successCountDownStatus = this._successCountDown.decrementAndGet();
            if (successCountDownStatus == 0) {
                this._completionTime = new Date();
                this._analysisListener.jobSuccess(this._analysisJobMetrics.getAnalysisJob(), this._analysisJobMetrics);
            }
        }
        finally {
            this._countDownLatch.countDown();
        }
    }

    public void onError(Task task, Throwable throwable) {
        try {
            logger.debug("onError(...)");
            this._analysisListener.errorUnknown(this._analysisJobMetrics.getAnalysisJob(), throwable);
        }
        finally {
            this._countDownLatch.countDown();
        }
    }

    @Override
    public Date getCompletionTime() {
        return this._completionTime;
    }
}

