/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.job.concurrent.CompositeTaskListener;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JoinTaskListener
implements TaskListener {
    private static final Logger logger = LoggerFactory.getLogger(JoinTaskListener.class);
    private final AtomicInteger _countDown;
    private final TaskListener _nestedTaskListener;
    private volatile Throwable _error;

    public JoinTaskListener(int tasksToWaitFor, TaskListener ... nestedTaskListeners) {
        this(tasksToWaitFor, (TaskListener)new CompositeTaskListener(nestedTaskListeners));
    }

    public JoinTaskListener(int tasksToWaitFor, TaskListener nestedTaskListener) {
        this._nestedTaskListener = nestedTaskListener;
        if (tasksToWaitFor == 0) {
            logger.warn("Was asked to join execution after 0 tasks, this might be a bug. Continuing with immediate completion.");
            this._countDown = new AtomicInteger(1);
            this.onComplete(null);
        } else {
            this._countDown = new AtomicInteger(tasksToWaitFor);
        }
    }

    public String toString() {
        return "Join[countDown=" + this._countDown.get() + "]";
    }

    public void onBegin(Task task) {
    }

    public void onComplete(Task task) {
        int count = this._countDown.decrementAndGet();
        logger.debug("onComplete(), count = {}", (Object)count);
        this.invokeNested(count, task);
    }

    public void onError(Task task, Throwable throwable) {
        this._error = throwable;
        int count = this._countDown.decrementAndGet();
        logger.debug("onComplete(), count = {}", (Object)count);
        this.invokeNested(count, task);
    }

    private void invokeNested(int count, Task task) {
        if (count == 0) {
            if (this._error == null) {
                logger.debug("Calling onComplete(...) on nested TaskListener ()");
                this._nestedTaskListener.onComplete(task);
            } else {
                logger.debug("Calling onError(...) on nested TaskListener ()");
                this._nestedTaskListener.onError(task, this._error);
            }
        }
    }
}

