/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.concurrent;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.datacleaner.job.concurrent.DaemonThreadFactory;
import org.datacleaner.job.concurrent.ScheduledTaskRunner;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunnable;
import org.datacleaner.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MultiThreadedTaskRunner
implements ScheduledTaskRunner {
    private static final Logger logger = LoggerFactory.getLogger(MultiThreadedTaskRunner.class);
    private final ThreadFactory _threadFactory;
    private final ExecutorService _executorService;
    private final ScheduledThreadPoolExecutor _executorScheduledService;
    private final int _numThreads;
    private final BlockingQueue<Runnable> _workQueue;

    public MultiThreadedTaskRunner() {
        this(30);
    }

    public MultiThreadedTaskRunner(int numThreads) {
        this._numThreads = numThreads;
        ThreadPoolExecutor.CallerRunsPolicy rejectionHandler = new ThreadPoolExecutor.CallerRunsPolicy();
        int taskCapacity = Math.max(1000, numThreads * 10);
        this._threadFactory = new DaemonThreadFactory();
        this._workQueue = new AlwaysBlockingQueue<Runnable>(taskCapacity);
        this._executorService = new ThreadPoolExecutor(numThreads, numThreads, 60L, TimeUnit.SECONDS, this._workQueue, this._threadFactory, rejectionHandler);
        this._executorScheduledService = new ScheduledThreadPoolExecutor(1);
        this._executorScheduledService.setMaximumPoolSize(50);
    }

    public int getNumThreads() {
        return this._numThreads;
    }

    public void run(Task task, TaskListener listener) {
        logger.debug("run({},{})", (Object)task, (Object)listener);
        this.executeInternal(new TaskRunnable(task, listener));
    }

    public void run(TaskRunnable taskRunnable) {
        logger.debug("run({})", (Object)taskRunnable);
        this.executeInternal(taskRunnable);
    }

    private void executeInternal(TaskRunnable taskRunnable) {
        try {
            this._executorService.execute((Runnable)taskRunnable);
        }
        catch (RejectedExecutionException e) {
            logger.error("Unexpected rejected execution!", (Throwable)e);
        }
    }

    public void runScheduled(Task task, TaskListener listener, long initialDelay, long delay, TimeUnit unit) {
        logger.debug("Schedule task ({},{}), delay {} {}", new Object[]{task, listener, delay, unit});
        this._executorScheduledService.scheduleWithFixedDelay((Runnable)new TaskRunnable(task, listener), initialDelay, delay, unit);
    }

    public void runScheduled(TaskRunnable taskRunnable, long initialDelay, long delay, TimeUnit unit) {
        logger.debug("Schedule task ({}), delay {} {}", new Object[]{taskRunnable, delay, unit});
        this._executorScheduledService.scheduleWithFixedDelay((Runnable)taskRunnable, initialDelay, delay, unit);
    }

    public void shutdown() {
        logger.info("shutdown() called, shutting down executor service");
        this._executorService.shutdown();
        this._executorScheduledService.shutdown();
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    public void assistExecution() {
        Runnable task = (Runnable)this._workQueue.poll();
        if (task != null) {
            task.run();
        }
    }

    class AlwaysBlockingQueue<T>
    extends ArrayBlockingQueue<T> {
        private static final long serialVersionUID = 1L;

        AlwaysBlockingQueue(int size) {
            super(size);
        }

        @Override
        public boolean offer(T task) {
            try {
                this.put(task);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }
}

