/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.metamodel.query.Query;
import org.datacleaner.api.HasAnalyzerResult;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.concurrent.ForkTaskListener;
import org.datacleaner.job.concurrent.JoinTaskListener;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunnable;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.runner.AnalysisJobMetricsImpl;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.ComponentMetrics;
import org.datacleaner.job.runner.ConsumeRowHandler;
import org.datacleaner.job.runner.ErrorAware;
import org.datacleaner.job.runner.JobAndResult;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingConsumerSorter;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.job.runner.RowProcessingMetricsImpl;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.runner.RowProcessingQueryOptimizer;
import org.datacleaner.job.runner.RowProcessingStream;
import org.datacleaner.job.runner.SimpleRowIdGenerator;
import org.datacleaner.job.runner.TransformerConsumer;
import org.datacleaner.job.tasks.CloseTaskListener;
import org.datacleaner.job.tasks.CollectResultsTask;
import org.datacleaner.job.tasks.InitializeTask;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.SourceColumnFinder;

public abstract class AbstractRowProcessingPublisher
implements RowProcessingPublisher {
    private final AtomicBoolean _success;
    private final RowProcessingPublishers _publishers;
    private final RowProcessingStream _stream;
    private final List<RowProcessingConsumer> _consumers;
    private final SourceColumnFinder _sourceColumnFinder;

    public AbstractRowProcessingPublisher(RowProcessingPublishers publishers, RowProcessingStream stream) {
        if (publishers == null) {
            throw new IllegalArgumentException("RowProcessingPublishers cannot be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("RowProcessingStream cannot be null");
        }
        this._publishers = publishers;
        this._stream = stream;
        this._sourceColumnFinder = new SourceColumnFinder();
        this._sourceColumnFinder.addSources(stream.getAnalysisJob());
        this._consumers = new ArrayList<RowProcessingConsumer>();
        this._success = new AtomicBoolean(true);
    }

    @Override
    public ErrorAware getErrorAware() {
        return this._publishers.getErrorAware();
    }

    protected abstract RowProcessingQueryOptimizer getQueryOptimizer();

    protected abstract boolean processRowsInternal(AnalysisListener var1, RowProcessingMetrics var2);

    @Override
    public final SourceColumnFinder getSourceColumnFinder() {
        return this._sourceColumnFinder;
    }

    @Override
    public final RowProcessingStream getStream() {
        return this._stream;
    }

    @Override
    public final List<RowProcessingConsumer> getConsumers() {
        return this._consumers;
    }

    protected final List<RowProcessingConsumer> getConsumersSorted() {
        List<RowProcessingConsumer> consumers = this.getConsumers();
        RowProcessingConsumerSorter sorter = new RowProcessingConsumerSorter(consumers);
        List<RowProcessingConsumer> sortedConsumers = sorter.createProcessOrderedConsumerList();
        return sortedConsumers;
    }

    @Override
    public final void registerConsumer(RowProcessingConsumer consumer) {
        this._consumers.add(consumer);
    }

    @Override
    public final RowProcessingMetrics getRowProcessingMetrics() {
        return new RowProcessingMetricsImpl(this._publishers, this);
    }

    @Override
    public final RowProcessingConsumer getConsumer(ComponentJob componentJob) {
        for (RowProcessingConsumer consumer : this._consumers) {
            if (!componentJob.equals(consumer.getComponentJob())) continue;
            return consumer;
        }
        return null;
    }

    @Override
    public final RowProcessingPublishers getPublishers() {
        return this._publishers;
    }

    @Override
    public final Query getQuery() {
        return this.getQueryOptimizer().getOptimizedQuery();
    }

    @Override
    public final ConsumeRowHandler createConsumeRowHandler() {
        RowProcessingQueryOptimizer queryOptimizer = this.getQueryOptimizer();
        Query finalQuery = queryOptimizer.getOptimizedQuery();
        SimpleRowIdGenerator idGenerator = finalQuery.getFirstRow() == null ? new SimpleRowIdGenerator() : new SimpleRowIdGenerator(finalQuery.getFirstRow());
        RowProcessingPublishers publishers = this.getPublishers();
        AnalysisListener analysisListener = publishers.getAnalysisListener();
        for (RowProcessingConsumer consumer : this.getConsumers()) {
            ComponentJob componentJob = consumer.getComponentJob();
            ComponentMetrics metrics = new AnalysisJobMetricsImpl(consumer.getAnalysisJob(), publishers).getComponentMetrics(componentJob);
            analysisListener.componentBegin(this.getStream().getAnalysisJob(), componentJob, metrics);
            if (!(consumer instanceof TransformerConsumer)) continue;
            ((TransformerConsumer)consumer).setRowIdGenerator(idGenerator);
        }
        List<RowProcessingConsumer> consumers = queryOptimizer.getOptimizedConsumers();
        Collection<? extends FilterOutcome> availableOutcomes = queryOptimizer.getOptimizedAvailableOutcomes();
        ConsumeRowHandler consumeRowHandler = new ConsumeRowHandler(consumers, availableOutcomes);
        return consumeRowHandler;
    }

    protected final Task createCollectResultTask(RowProcessingConsumer consumer, Queue<JobAndResult> resultQueue) {
        Object component = consumer.getComponent();
        if (component instanceof HasAnalyzerResult) {
            HasAnalyzerResult hasAnalyzerResult = (HasAnalyzerResult)component;
            AnalysisListener analysisListener = this._publishers.getAnalysisListener();
            return new CollectResultsTask(hasAnalyzerResult, this._stream.getAnalysisJob(), consumer.getComponentJob(), resultQueue, analysisListener);
        }
        return null;
    }

    protected final TaskRunnable createCloseTask(RowProcessingConsumer consumer, TaskListener closeTaskListener) {
        LifeCycleHelper lifeCycleHelper = this._publishers.getConsumerSpecificLifeCycleHelper(consumer);
        CloseTaskListener taskListener = new CloseTaskListener(lifeCycleHelper, this, consumer, this._success, closeTaskListener, this._publishers.getAnalysisListener(), this._stream.getAnalysisJob());
        return new TaskRunnable(null, (TaskListener)taskListener);
    }

    protected final TaskRunnable createInitTask(RowProcessingConsumer consumer, TaskListener listener) {
        LifeCycleHelper lifeCycleHelper = this._publishers.getConsumerSpecificLifeCycleHelper(consumer);
        InitializeTask task = new InitializeTask(lifeCycleHelper, this, consumer);
        return new TaskRunnable((Task)task, listener);
    }

    @Override
    public final void processRows(RowProcessingMetrics rowProcessingMetrics) {
        AnalysisListener analysisListener = this.getAnalysisListener();
        boolean success = this.processRowsInternal(analysisListener, rowProcessingMetrics);
        if (!success) {
            this._success.set(false);
            return;
        }
        analysisListener.rowProcessingSuccess(this.getAnalysisJob(), rowProcessingMetrics);
    }

    @Override
    public final boolean runRowProcessing(Queue<JobAndResult> resultQueue, TaskListener finishedTaskListener) {
        if (!this.isReadyForRowProcessing()) {
            return false;
        }
        List<TaskRunnable> postProcessingTasks = this.createPostProcessingTasks(resultQueue, finishedTaskListener);
        return this.runRowProcessingInternal(postProcessingTasks);
    }

    protected boolean isReadyForRowProcessing() {
        return true;
    }

    protected abstract boolean runRowProcessingInternal(List<TaskRunnable> var1);

    private List<TaskRunnable> createPostProcessingTasks(Queue<JobAndResult> resultQueue, TaskListener finishedTaskListener) {
        List<RowProcessingConsumer> configurableConsumers = this.getConsumers();
        int numConsumers = configurableConsumers.size();
        JoinTaskListener closeTaskListener = new JoinTaskListener(numConsumers, finishedTaskListener);
        ArrayList<TaskRunnable> closeTasks = new ArrayList<TaskRunnable>();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            closeTasks.add(this.createCloseTask(consumer, closeTaskListener));
        }
        ForkTaskListener getResultCompletionListener = new ForkTaskListener("collect results (" + this.getStream() + ")", this.getTaskRunner(), closeTasks);
        JoinTaskListener getResultTaskListener = new JoinTaskListener(numConsumers, (TaskListener)getResultCompletionListener);
        ArrayList<TaskRunnable> getResultTasks = new ArrayList<TaskRunnable>();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            Task collectResultTask = this.createCollectResultTask(consumer, resultQueue);
            if (collectResultTask == null) {
                getResultTasks.add(new TaskRunnable(null, (TaskListener)getResultTaskListener));
                continue;
            }
            getResultTasks.add(new TaskRunnable(collectResultTask, (TaskListener)getResultTaskListener));
        }
        return getResultTasks;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[stream=" + this.getStream() + ", consumers=" + this._consumers.size() + "]";
    }

    protected final TaskRunner getTaskRunner() {
        return this.getPublishers().getTaskRunner();
    }

    @Override
    public final AnalysisJob getAnalysisJob() {
        return this.getStream().getAnalysisJob();
    }

    @Override
    public final AnalysisListener getAnalysisListener() {
        return this.getPublishers().getAnalysisListener();
    }

    @Override
    public final void initializeConsumers(TaskListener finishedListener) {
        TaskRunner taskRunner = this.getTaskRunner();
        List<RowProcessingConsumer> configurableConsumers = this.getConsumers();
        int numConfigurableConsumers = configurableConsumers.size();
        JoinTaskListener initFinishedListener = new JoinTaskListener(numConfigurableConsumers, finishedListener);
        for (RowProcessingConsumer consumer : configurableConsumers) {
            TaskRunnable task = this.createInitTask(consumer, initFinishedListener);
            taskRunner.run(task);
        }
    }

    @Override
    public final void closeConsumers() {
        TaskRunner taskRunner = this.getTaskRunner();
        List<RowProcessingConsumer> configurableConsumers = this.getConsumers();
        for (RowProcessingConsumer consumer : configurableConsumers) {
            TaskRunnable task = this.createCloseTask(consumer, null);
            taskRunner.run(task);
        }
    }
}

