/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.HasOutputDataStreams;
import org.datacleaner.api.OutputDataStream;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.job.runner.ConsumeRowHandler;
import org.datacleaner.job.runner.OutputDataStreamRowCollector;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.util.ConcurrencyUtils;

public class ActiveOutputDataStream
implements Closeable {
    private final OutputDataStreamJob _outputDataStreamJob;
    private final RowProcessingPublisher _publisher;
    private final HasOutputDataStreams _component;
    private final CountDownLatch _countDownLatch;
    private OutputDataStreamRowCollector _outputRowCollector;

    public ActiveOutputDataStream(OutputDataStreamJob outputDataStreamJob, RowProcessingPublisher publisher, HasOutputDataStreams component) {
        this._outputDataStreamJob = outputDataStreamJob;
        this._publisher = publisher;
        this._component = component;
        this._countDownLatch = new CountDownLatch(1);
    }

    public RowProcessingPublisher getPublisher() {
        return this._publisher;
    }

    public HasOutputDataStreams getComponent() {
        return this._component;
    }

    public OutputDataStreamJob getOutputDataStreamJob() {
        return this._outputDataStreamJob;
    }

    public void initialize() {
        Table table = this._outputDataStreamJob.getOutputDataStream().getTable();
        Query query = new Query();
        query.from(table).selectAll();
        List selectItems = query.getSelectClause().getItems();
        ConsumeRowHandler consumeRowHandler = this._publisher.createConsumeRowHandler();
        this._outputRowCollector = new OutputDataStreamRowCollector(this._publisher, selectItems, consumeRowHandler);
        OutputDataStream outputDataStream = this._outputDataStreamJob.getOutputDataStream();
        this._component.initializeOutputDataStream(outputDataStream, query, (OutputRowCollector)this._outputRowCollector);
        this._publisher.getAnalysisListener().rowProcessingBegin(this._publisher.getAnalysisJob(), this._publisher.getRowProcessingMetrics());
    }

    public void await() throws InterruptedException {
        ConcurrencyUtils.awaitCountDown(this._countDownLatch, "stream: " + this._outputDataStreamJob.getOutputDataStream());
    }

    @Override
    public void close() {
        this._countDownLatch.countDown();
    }
}

