/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import org.apache.metamodel.schema.Table;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.ComponentMetrics;
import org.datacleaner.job.runner.ComponentMetricsImpl;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.runner.RowProcessingStream;
import org.datacleaner.util.SourceColumnFinder;

final class AnalysisJobMetricsImpl
implements AnalysisJobMetrics {
    private final AnalysisJob _job;
    private final RowProcessingPublishers _publishers;

    public AnalysisJobMetricsImpl(AnalysisJob job, RowProcessingPublishers publishers) {
        this._job = job;
        this._publishers = publishers;
    }

    @Override
    public AnalysisJob getAnalysisJob() {
        return this._job;
    }

    @Override
    public ComponentMetrics getComponentMetrics(ComponentJob componentJob) {
        Table table = this.getRowProcessingTable(componentJob);
        RowProcessingMetrics rowProcessingMetrics = this.getRowProcessingMetrics(table);
        return new ComponentMetricsImpl(rowProcessingMetrics, componentJob);
    }

    @Override
    public Table[] getRowProcessingTables() {
        return this._publishers.getTables();
    }

    @Override
    public RowProcessingMetrics getRowProcessingMetrics(Table table) {
        RowProcessingStream stream = this._publishers.getStream(table);
        RowProcessingPublisher publisher = this._publishers.getRowProcessingPublisher(stream);
        if (publisher == null) {
            return null;
        }
        return publisher.getRowProcessingMetrics();
    }

    @Override
    public Table getRowProcessingTable(ComponentJob componentJob) {
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(this._job);
        Table[] tables = this._publishers.getTables(sourceColumnFinder, componentJob);
        if (tables == null || tables.length == 0) {
            return null;
        }
        return tables[0];
    }
}

