/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.concurrent.StatusAwareTaskListener;
import org.datacleaner.job.runner.AnalysisJobCancellation;
import org.datacleaner.job.runner.AnalysisJobFailedException;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.ErrorAware;
import org.datacleaner.job.runner.JobAndResult;
import org.datacleaner.job.runner.JobStatus;
import org.datacleaner.result.AbstractAnalysisResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysisResultFutureImpl
extends AbstractAnalysisResult
implements AnalysisResultFuture {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisResultFutureImpl.class);
    private final Queue<JobAndResult> _resultQueue;
    private final ErrorAware _errorAware;
    private final StatusAwareTaskListener _jobTaskListener;
    private volatile boolean _done;

    public AnalysisResultFutureImpl(Queue<JobAndResult> resultQueue, StatusAwareTaskListener jobCompletionListener, ErrorAware errorAware) {
        this._resultQueue = resultQueue;
        this._jobTaskListener = jobCompletionListener;
        this._errorAware = errorAware;
        this._done = false;
    }

    @Override
    public boolean isDone() {
        if (!this._done) {
            this._done = this._jobTaskListener.isDone();
        }
        return this._done;
    }

    @Override
    public Date getCreationDate() {
        return this._jobTaskListener.getCompletionTime();
    }

    @Override
    public void cancel() {
        if (!this._done) {
            this._jobTaskListener.onError(null, new AnalysisJobCancellation());
        }
    }

    @Override
    public void await(long timeout, TimeUnit timeUnit) {
        if (!this.isDone()) {
            try {
                logger.debug("_closeCompletionListener.await({},{})", (Object)timeout, (Object)timeUnit);
                this._jobTaskListener.await(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                logger.error("Unexpected error while retreiving results", (Throwable)e);
            }
        }
    }

    @Override
    public void await() {
        while (!this.isDone()) {
            try {
                logger.debug("_closeCompletionListener.await()");
                this._jobTaskListener.await();
            }
            catch (Exception e) {
                logger.error("Unexpected error while retreiving results", (Throwable)e);
            }
        }
    }

    @Override
    public List<AnalyzerResult> getResults() throws IllegalStateException {
        this.await();
        if (this.isErrornous()) {
            throw new AnalysisJobFailedException(this.getErrors());
        }
        ArrayList<JobAndResult> resultQueueCopy = new ArrayList<JobAndResult>(this._resultQueue);
        ArrayList<AnalyzerResult> result = new ArrayList<AnalyzerResult>(resultQueueCopy.size());
        for (JobAndResult jobResult : resultQueueCopy) {
            result.add(jobResult.getResult());
        }
        return result;
    }

    @Override
    public AnalyzerResult getResult(ComponentJob componentJob) throws AnalysisJobFailedException {
        this.await();
        if (this.isErrornous()) {
            throw new AnalysisJobFailedException(this.getErrors());
        }
        ArrayList<JobAndResult> resultQueueCopy = new ArrayList<JobAndResult>(this._resultQueue);
        for (JobAndResult jobResult : resultQueueCopy) {
            if (!jobResult.getJob().equals(componentJob)) continue;
            return jobResult.getResult();
        }
        return null;
    }

    @Override
    public Map<ComponentJob, AnalyzerResult> getResultMap() throws IllegalStateException {
        this.await();
        if (this.isErrornous()) {
            throw new AnalysisJobFailedException(this.getErrors());
        }
        ArrayList<JobAndResult> resultQueueCopy = new ArrayList<JobAndResult>(this._resultQueue);
        HashMap<ComponentJob, AnalyzerResult> result = new HashMap<ComponentJob, AnalyzerResult>();
        for (JobAndResult jobResult : resultQueueCopy) {
            ComponentJob job = jobResult.getJob();
            AnalyzerResult analyzerResult = jobResult.getResult();
            result.put(job, analyzerResult);
        }
        return result;
    }

    @Override
    public boolean isSuccessful() {
        this.await();
        return !this._errorAware.isErrornous();
    }

    @Override
    public List<Throwable> getErrors() {
        return this._errorAware.getErrors();
    }

    @Override
    public boolean isErrornous() {
        return !this.isSuccessful();
    }

    @Override
    public JobStatus getStatus() {
        if (this.isDone()) {
            if (this.isSuccessful()) {
                return JobStatus.SUCCESSFUL;
            }
            return JobStatus.ERRORNOUS;
        }
        if (!this._errorAware.isErrornous()) {
            return JobStatus.NOT_FINISHED;
        }
        return JobStatus.ERRORNOUS;
    }

    @Override
    public boolean isCancelled() {
        return this._errorAware.isCancelled();
    }
}

