/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.InputColumn;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.job.concurrent.JobCompletionTaskListener;
import org.datacleaner.job.concurrent.JoinTaskListener;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalysisResultFuture;
import org.datacleaner.job.runner.AnalysisResultFutureImpl;
import org.datacleaner.job.runner.ErrorAware;
import org.datacleaner.job.runner.JobAndResult;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.SourceColumnFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AnalysisRunnerJobDelegate {
    private static final Logger logger = LoggerFactory.getLogger(AnalysisRunnerJobDelegate.class);
    private final AnalysisJob _job;
    private final DataCleanerConfiguration _configuration;
    private final TaskRunner _taskRunner;
    private final AnalysisListener _analysisListener;
    private final Queue<JobAndResult> _resultQueue;
    private final ErrorAware _errorAware;
    private final boolean _includeNonDistributedTasks;

    public AnalysisRunnerJobDelegate(AnalysisJob job, DataCleanerConfiguration configuration, TaskRunner taskRunner, AnalysisListener analysisListener, Queue<JobAndResult> resultQueue, ErrorAware errorAware, boolean includeNonDistributedTasks) {
        this._job = job;
        this._configuration = configuration;
        this._taskRunner = taskRunner;
        this._analysisListener = analysisListener;
        this._resultQueue = resultQueue;
        this._includeNonDistributedTasks = includeNonDistributedTasks;
        this._errorAware = errorAware;
    }

    public AnalysisResultFuture run() {
        try {
            InjectionManager injectionManager = this._configuration.getEnvironment().getInjectionManagerFactory().getInjectionManager(this._configuration, this._job);
            LifeCycleHelper rowProcessingLifeCycleHelper = new LifeCycleHelper(injectionManager, this._includeNonDistributedTasks);
            RowProcessingPublishers publishers = new RowProcessingPublishers(this._job, this._analysisListener, this._errorAware, this._taskRunner, rowProcessingLifeCycleHelper);
            AnalysisJobMetrics analysisJobMetrics = publishers.getAnalysisJobMetrics();
            JobCompletionTaskListener jobCompletionTaskListener = new JobCompletionTaskListener(analysisJobMetrics, this._analysisListener, 1);
            this._analysisListener.jobBegin(this._job, analysisJobMetrics);
            this.validateSingleTableInput(this._job);
            this.scheduleRowProcessing(publishers, rowProcessingLifeCycleHelper, jobCompletionTaskListener, analysisJobMetrics);
            return new AnalysisResultFutureImpl(this._resultQueue, jobCompletionTaskListener, this._errorAware);
        }
        catch (RuntimeException e) {
            this._analysisListener.errorUnknown(this._job, e);
            throw e;
        }
    }

    private void scheduleRowProcessing(RowProcessingPublishers publishers, LifeCycleHelper lifeCycleHelper, JobCompletionTaskListener jobCompletionTaskListener, AnalysisJobMetrics analysisJobMetrics) {
        logger.info("Created {} row processor publisher(s)", (Object)publishers.size());
        JoinTaskListener rowProcessorPublishersDoneCompletionListener = new JoinTaskListener(publishers.size(), (TaskListener)jobCompletionTaskListener);
        Collection<RowProcessingPublisher> rowProcessingPublishers = publishers.getRowProcessingPublishers();
        logger.debug("RowProcessingPublishers: {}", rowProcessingPublishers);
        this.dispatchWhenReady(rowProcessingPublishers, rowProcessorPublishersDoneCompletionListener);
    }

    private void dispatchWhenReady(Collection<RowProcessingPublisher> rowProcessingPublishers, TaskListener rowProcessorPublishersDoneCompletionListener) {
        LinkedList<RowProcessingPublisher> remainingRowProcessingPublishers = new LinkedList<RowProcessingPublisher>(rowProcessingPublishers);
        while (!remainingRowProcessingPublishers.isEmpty()) {
            boolean progressThisIteration = false;
            Iterator it = remainingRowProcessingPublishers.iterator();
            while (it.hasNext()) {
                RowProcessingPublisher rowProcessingPublisher = (RowProcessingPublisher)it.next();
                boolean started = rowProcessingPublisher.runRowProcessing(this._resultQueue, rowProcessorPublishersDoneCompletionListener);
                if (!started) continue;
                logger.debug("Scheduled row processing publisher: {}", (Object)rowProcessingPublisher);
                it.remove();
                progressThisIteration = true;
            }
            if (progressThisIteration) continue;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void validateSingleTableInput(AnalysisJob job) {
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(job);
        this.validateSingleTableInput(sourceColumnFinder, job.getTransformerJobs());
        this.validateSingleTableInput(sourceColumnFinder, job.getFilterJobs());
        this.validateSingleTableInput(sourceColumnFinder, job.getAnalyzerJobs());
    }

    private void validateSingleTableInput(SourceColumnFinder sourceColumnFinder, Collection<? extends ComponentJob> componentJobs) {
        for (ComponentJob componentJob : componentJobs) {
            OutputDataStreamJob[] outputDataStreamJobs;
            if (!componentJob.getDescriptor().isMultiStreamComponent()) {
                InputColumn[] input;
                Table originatingTable = null;
                InputColumn[] inputColumnArray = input = componentJob.getInput();
                int n = inputColumnArray.length;
                for (int i = 0; i < n; ++i) {
                    InputColumn inputColumn = inputColumnArray[i];
                    Table table = sourceColumnFinder.findOriginatingTable(inputColumn);
                    if (table == null) continue;
                    if (originatingTable == null) {
                        originatingTable = table;
                        continue;
                    }
                    if (originatingTable.equals(table)) continue;
                    throw new IllegalArgumentException("Input columns in " + componentJob + " originate from different tables");
                }
            }
            for (OutputDataStreamJob outputDataStreamJob : outputDataStreamJobs = componentJob.getOutputDataStreamJobs()) {
                this.validateSingleTableInput(outputDataStreamJob.getJob());
            }
        }
    }
}

