/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.List;
import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.ComponentMessage;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.ComponentMetrics;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeAnalysisListener
implements AnalysisListener {
    private static final Logger logger = LoggerFactory.getLogger(CompositeAnalysisListener.class);
    private final List<AnalysisListener> _delegates;

    public CompositeAnalysisListener(AnalysisListener[] delegates) {
        this._delegates = new ArrayList<AnalysisListener>(delegates.length);
        for (AnalysisListener analysisListener : delegates) {
            this.addDelegate(analysisListener);
        }
    }

    public CompositeAnalysisListener(AnalysisListener firstDelegate, AnalysisListener ... delegates) {
        this._delegates = new ArrayList<AnalysisListener>(1 + delegates.length);
        this.addDelegate(firstDelegate);
        for (AnalysisListener analysisListener : delegates) {
            this.addDelegate(analysisListener);
        }
    }

    public void addDelegate(AnalysisListener analysisListener) {
        if (analysisListener == null) {
            return;
        }
        this._delegates.add(analysisListener);
    }

    public boolean isEmpty() {
        return this._delegates.isEmpty();
    }

    public int size() {
        return this._delegates.size();
    }

    @Override
    public void jobBegin(AnalysisJob job, AnalysisJobMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.jobBegin(job, metrics);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void onComponentMessage(AnalysisJob job, ComponentJob componentJob, ComponentMessage message) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.onComponentMessage(job, componentJob, message);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void jobSuccess(AnalysisJob job, AnalysisJobMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.jobSuccess(job, metrics);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void rowProcessingBegin(AnalysisJob job, RowProcessingMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.rowProcessingBegin(job, metrics);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void rowProcessingProgress(AnalysisJob job, RowProcessingMetrics metrics, InputRow row, int currentRow) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.rowProcessingProgress(job, metrics, row, currentRow);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void rowProcessingSuccess(AnalysisJob job, RowProcessingMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.rowProcessingSuccess(job, metrics);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void componentBegin(AnalysisJob job, ComponentJob componentJob, ComponentMetrics metrics) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.componentBegin(job, componentJob, metrics);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void componentSuccess(AnalysisJob job, ComponentJob componentJob, AnalyzerResult result) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.componentSuccess(job, componentJob, result);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void errorInComponent(AnalysisJob job, ComponentJob componentJob, InputRow row, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.errorInComponent(job, componentJob, row, throwable);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }

    @Override
    public void errorUnknown(AnalysisJob job, Throwable throwable) {
        for (AnalysisListener delegate : this._delegates) {
            try {
                delegate.errorUnknown(job, throwable);
            }
            catch (Exception e) {
                logger.warn("Listener {} failed", (Object)delegate.getClass().getName(), (Object)e);
            }
        }
    }
}

