/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.metamodel.schema.Table;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.configuration.DataCleanerConfiguration;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.configuration.InjectionManagerFactory;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.concurrent.SingleThreadedTaskRunner;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.CompositeAnalysisListener;
import org.datacleaner.job.runner.ConsumeRowHandlerDelegate;
import org.datacleaner.job.runner.ConsumeRowResult;
import org.datacleaner.job.runner.ErrorAwareAnalysisListener;
import org.datacleaner.job.runner.FilterOutcomesImpl;
import org.datacleaner.job.runner.InfoLoggingAnalysisListener;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingConsumerSorter;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumeRowHandler {
    private static final Logger logger = LoggerFactory.getLogger(ConsumeRowHandler.class);
    private final List<RowProcessingConsumer> _consumers;
    private final Collection<? extends FilterOutcome> _alwaysSatisfiedOutcomes;

    public ConsumeRowHandler(AnalysisJob job, DataCleanerConfiguration configuration, Configuration rowConsumerConfiguration) {
        this._consumers = this.extractConsumers(job, configuration, rowConsumerConfiguration);
        this._alwaysSatisfiedOutcomes = rowConsumerConfiguration.alwaysSatisfiedOutcomes;
    }

    public ConsumeRowHandler(List<RowProcessingConsumer> consumers) {
        this(consumers, null);
    }

    public ConsumeRowHandler(List<RowProcessingConsumer> consumers, Collection<? extends FilterOutcome> alwaysSatisfiedOutcomes) {
        this._consumers = consumers;
        this._alwaysSatisfiedOutcomes = alwaysSatisfiedOutcomes;
    }

    public List<RowProcessingConsumer> getConsumers() {
        return this._consumers;
    }

    public List<InputColumn<?>> getOutputColumns() {
        ArrayList result = new ArrayList();
        for (RowProcessingConsumer consumer : this._consumers) {
            InputColumn<?>[] outputColumns;
            for (InputColumn<?> outputColumn : outputColumns = consumer.getOutputColumns()) {
                result.add(outputColumn);
            }
        }
        return result;
    }

    @Deprecated
    public List<InputRow> consume(InputRow row) {
        ConsumeRowResult result = this.consumeRow(row);
        return result.getRows();
    }

    public ConsumeRowResult consumeRow(InputRow row) {
        FilterOutcomesImpl outcomes = new FilterOutcomesImpl(this._alwaysSatisfiedOutcomes);
        ConsumeRowHandlerDelegate delegate = new ConsumeRowHandlerDelegate(this._consumers, row, 0, outcomes);
        ConsumeRowResult result = delegate.consume();
        return result;
    }

    private List<RowProcessingConsumer> extractConsumers(AnalysisJob analysisJob, DataCleanerConfiguration configuration, Configuration rowConsumeConfiguration) {
        RowProcessingPublisher publisher;
        InjectionManagerFactory injectionManagerFactory = configuration.getEnvironment().getInjectionManagerFactory();
        InjectionManager injectionManager = injectionManagerFactory.getInjectionManager(configuration, analysisJob);
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, rowConsumeConfiguration.includeNonDistributedTasks);
        SingleThreadedTaskRunner taskRunner = new SingleThreadedTaskRunner();
        ErrorAwareAnalysisListener errorAwareAnalysisListener = new ErrorAwareAnalysisListener();
        CompositeAnalysisListener analysisListener = new CompositeAnalysisListener(rowConsumeConfiguration.analysisListener, errorAwareAnalysisListener);
        RowProcessingPublishers rowProcessingPublishers = new RowProcessingPublishers(analysisJob, (AnalysisListener)analysisListener, errorAwareAnalysisListener, taskRunner, lifeCycleHelper);
        if (rowConsumeConfiguration.table != null) {
            RowProcessingPublisher tablePublisher = rowProcessingPublishers.getRowProcessingPublisher(rowConsumeConfiguration.table);
            if (tablePublisher == null) {
                throw new IllegalArgumentException("Job does not consume records from table: " + rowConsumeConfiguration.table);
            }
            publisher = tablePublisher;
        } else {
            Collection<RowProcessingPublisher> publishers = rowProcessingPublishers.getRowProcessingPublishers();
            publisher = publishers.iterator().next();
            for (RowProcessingPublisher aPublisher : publishers) {
                if (aPublisher == publisher || !aPublisher.getStream().isSourceTable()) continue;
                throw new IllegalArgumentException("Job consumes multiple source tables, but ConsumeRowHandler can only handle a single table's components. Please specify a Table constructor argument.");
            }
        }
        final AtomicReference errorReference = new AtomicReference();
        publisher.initializeConsumers(new TaskListener(){

            public void onError(Task task, Throwable throwable) {
                logger.error("Exception thrown while initializing consumers.", throwable);
                errorReference.compareAndSet(null, throwable);
            }

            public void onComplete(Task task) {
                logger.info("Consumers initialized successfully.");
            }

            public void onBegin(Task task) {
                logger.info("Beginning the process of initializing consumers.");
            }
        });
        Throwable throwable = (Throwable)errorReference.get();
        if (throwable == null || throwable instanceof RuntimeException) {
            // empty if block
        }
        List<RowProcessingConsumer> consumers = publisher.getConsumers();
        if (!rowConsumeConfiguration.includeAnalyzers) {
            consumers = this.removeAnalyzers(consumers);
        }
        RowProcessingConsumerSorter sorter = new RowProcessingConsumerSorter(consumers);
        consumers = sorter.createProcessOrderedConsumerList();
        return consumers;
    }

    private List<RowProcessingConsumer> removeAnalyzers(List<RowProcessingConsumer> consumers) {
        ArrayList<RowProcessingConsumer> result = new ArrayList<RowProcessingConsumer>();
        for (RowProcessingConsumer rowProcessingConsumer : consumers) {
            Object component = rowProcessingConsumer.getComponent();
            if (component instanceof Analyzer) continue;
            result.add(rowProcessingConsumer);
        }
        return result;
    }

    public static class Configuration {
        public boolean includeNonDistributedTasks = true;
        public AnalysisListener analysisListener = new InfoLoggingAnalysisListener();
        public boolean includeAnalyzers = true;
        public Collection<? extends FilterOutcome> alwaysSatisfiedOutcomes;
        public Table table;
    }
}

