/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import org.datacleaner.api.AnalyzerResult;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisListenerAdaptor;
import org.datacleaner.job.runner.ComponentMetrics;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugLoggingAnalysisListener
extends AnalysisListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(DebugLoggingAnalysisListener.class);

    public static boolean isEnabled() {
        return logger.isDebugEnabled();
    }

    @Override
    public void jobBegin(AnalysisJob job, AnalysisJobMetrics metrics) {
        logger.debug("jobBegin({})", (Object)job);
    }

    @Override
    public void jobSuccess(AnalysisJob job, AnalysisJobMetrics metrics) {
        logger.debug("jobSuccess({})", (Object)job);
    }

    @Override
    public void rowProcessingBegin(AnalysisJob job, RowProcessingMetrics metrics) {
        logger.debug("rowProcessingBegin({}, {})", new Object[]{job, metrics.getTable()});
    }

    @Override
    public void rowProcessingProgress(AnalysisJob job, RowProcessingMetrics metrics, InputRow row, int currentRow) {
        logger.debug("rowProcessingProgress({}, {}, {}, {})", new Object[]{job, metrics.getTable(), row, currentRow});
    }

    @Override
    public void rowProcessingSuccess(AnalysisJob job, RowProcessingMetrics metrics) {
        logger.debug("rowProcessingSuccess({}, {})", new Object[]{job, metrics.getTable()});
    }

    @Override
    public void componentBegin(AnalysisJob job, ComponentJob componentJob, ComponentMetrics metrics) {
        logger.debug("componentBegin({}, {})", new Object[]{job, componentJob});
    }

    @Override
    public void componentSuccess(AnalysisJob job, ComponentJob componentJob, AnalyzerResult result) {
        logger.debug("componentSuccess({}, {})", new Object[]{job, componentJob, result});
    }

    @Override
    public void errorInComponent(AnalysisJob job, ComponentJob componentJob, InputRow row, Throwable throwable) {
        logger.debug("errorInComponent(" + job + "," + componentJob + "," + row + ")", throwable);
    }

    @Override
    public void errorUknown(AnalysisJob job, Throwable throwable) {
        logger.debug("errorUknown(" + job + ")", throwable);
    }
}

