/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.datacleaner.api.InputRow;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.concurrent.PreviousErrorsExistException;
import org.datacleaner.job.runner.AnalysisJobCancellation;
import org.datacleaner.job.runner.AnalysisListenerAdaptor;
import org.datacleaner.job.runner.ErrorAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ErrorAwareAnalysisListener
extends AnalysisListenerAdaptor
implements ErrorAware {
    private static final Logger logger = LoggerFactory.getLogger(ErrorAwareAnalysisListener.class);
    private final List<Throwable> _errors = new LinkedList<Throwable>();
    private final AtomicBoolean _cancelled = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleError(AnalysisJob job, Throwable throwable) {
        boolean cancellation = throwable instanceof AnalysisJobCancellation;
        if (cancellation) {
            this._cancelled.set(true);
        }
        if (!cancellation && !(throwable instanceof PreviousErrorsExistException)) {
            logger.warn("Exception stack trace:", throwable);
        }
        List<Throwable> list = this._errors;
        synchronized (list) {
            if (!this._errors.contains(throwable)) {
                this._errors.add(throwable);
            }
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            SQLException nextException;
            if (!(t instanceof SQLException) || (nextException = ((SQLException)t).getNextException()) == null) continue;
            logger.warn("SQLException.getNextException() stack trace:", (Throwable)nextException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Throwable> getErrors() {
        ArrayList<Throwable> result;
        List<Throwable> list = this._errors;
        synchronized (list) {
            result = new ArrayList<Throwable>(this._errors);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isErrornous() {
        List<Throwable> list = this._errors;
        synchronized (list) {
            return !this._errors.isEmpty();
        }
    }

    @Override
    public void errorInFilter(AnalysisJob job, FilterJob filterJob, InputRow row, Throwable throwable) {
        logger.warn("errorInFilter({},{},{},{})", new Object[]{job, filterJob, row, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public void errorInTransformer(AnalysisJob job, TransformerJob transformerJob, InputRow row, Throwable throwable) {
        logger.warn("errorInTransformer({},{},{},{})", new Object[]{job, transformerJob, row, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public void errorInAnalyzer(AnalysisJob job, AnalyzerJob analyzerJob, InputRow row, Throwable throwable) {
        logger.warn("errorInAnalyzer({},{},{},{})", new Object[]{job, analyzerJob, row, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public void errorUnknown(AnalysisJob job, Throwable throwable) {
        logger.warn("errorUnknown({},{})", new Object[]{job, throwable});
        this.handleError(job, throwable);
    }

    @Override
    public boolean isCancelled() {
        return this._cancelled.get();
    }
}

