/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.List;
import org.datacleaner.job.concurrent.PreviousErrorsExistException;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunnable;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.runner.ErrorAware;
import org.datacleaner.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ErrorAwareTaskRunnerWrapper
implements TaskRunner,
ErrorAware {
    private static final Logger logger = LoggerFactory.getLogger(ErrorAwareTaskRunnerWrapper.class);
    private final PreviousErrorsExistException _previousErrorsExistException = new PreviousErrorsExistException("A previous exception has occurred");
    private final TaskRunner _taskRunner;
    private final ErrorAware _errorAware;

    public ErrorAwareTaskRunnerWrapper(ErrorAware errorAware, TaskRunner taskRunner) {
        this._taskRunner = taskRunner;
        this._errorAware = errorAware;
    }

    public void run(Task task, TaskListener taskListener) {
        if (this.isErrornous()) {
            taskListener.onError(task, (Throwable)this._previousErrorsExistException);
        } else if (this.isCancelled()) {
            logger.info("Ignoring task because job has been cancelled: {}", (Object)task);
            taskListener.onError(task, (Throwable)this._previousErrorsExistException);
        } else {
            this._taskRunner.run(task, taskListener);
        }
    }

    public void run(TaskRunnable taskRunnable) {
        this.run(taskRunnable.getTask(), taskRunnable.getListener());
    }

    public void shutdown() {
        this._taskRunner.shutdown();
    }

    @Override
    public boolean isErrornous() {
        return this._errorAware.isErrornous();
    }

    @Override
    public List<Throwable> getErrors() {
        return this._errorAware.getErrors();
    }

    @Override
    public boolean isCancelled() {
        return this._errorAware.isCancelled();
    }

    public void assistExecution() {
        if (!this.isErrornous() && !this.isCancelled()) {
            this._taskRunner.assistExecution();
        }
    }
}

