/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.metamodel.data.CachingDataSetHeader;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.data.MetaModelInputRow;
import org.datacleaner.job.concurrent.PreviousErrorsExistException;
import org.datacleaner.job.runner.ConsumeRowHandler;
import org.datacleaner.job.runner.ErrorAware;
import org.datacleaner.job.runner.RowProcessingPublisher;

public class OutputDataStreamRowCollector
implements OutputRowCollector {
    private final CachingDataSetHeader _dataSetHeader;
    private final AtomicInteger _rowCounter;
    private final ConsumeRowHandler _consumeRowHandler;
    private final RowProcessingPublisher _publisher;

    public OutputDataStreamRowCollector(RowProcessingPublisher publisher, List<SelectItem> selectItems, ConsumeRowHandler consumeRowHandler) {
        this._publisher = publisher;
        this._dataSetHeader = new CachingDataSetHeader(selectItems);
        this._consumeRowHandler = consumeRowHandler;
        this._rowCounter = new AtomicInteger();
    }

    public void putValues(Object ... values) {
        DefaultRow row = new DefaultRow((DataSetHeader)this._dataSetHeader, values);
        this.putRow((Row)row);
    }

    public void putRow(Row row) {
        ErrorAware errorAware = this._publisher.getErrorAware();
        if (errorAware.isCancelled() || errorAware.isErrornous()) {
            throw new PreviousErrorsExistException();
        }
        int rowNumber = this._rowCounter.incrementAndGet();
        MetaModelInputRow inputRow = new MetaModelInputRow(rowNumber, row);
        this._consumeRowHandler.consumeRow(inputRow);
        this._publisher.getAnalysisListener().rowProcessingProgress(this._publisher.getAnalysisJob(), this._publisher.getRowProcessingMetrics(), inputRow, rowNumber);
    }
}

