/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.Collection;
import java.util.List;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Table;
import org.datacleaner.job.concurrent.ForkTaskListener;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunnable;
import org.datacleaner.job.runner.AbstractRowProcessingPublisher;
import org.datacleaner.job.runner.ActiveOutputDataStream;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.NoopRowProcessingQueryOptimizer;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.runner.RowProcessingQueryOptimizer;
import org.datacleaner.job.runner.RowProcessingStream;
import org.datacleaner.job.tasks.RunRowProcessingPublisherTask;
import org.datacleaner.job.tasks.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OutputDataStreamRowProcessingPublisher
extends AbstractRowProcessingPublisher {
    private static final Logger logger = LoggerFactory.getLogger(OutputDataStreamRowProcessingPublisher.class);
    private final RowProcessingConsumer _parentConsumer;

    public OutputDataStreamRowProcessingPublisher(RowProcessingPublishers publishers, RowProcessingConsumer parentConsumer, RowProcessingStream stream) {
        super(publishers, stream);
        if (parentConsumer == null) {
            throw new IllegalArgumentException("Parent RowProcessingConsumer cannot be null");
        }
        this._parentConsumer = parentConsumer;
    }

    @Override
    public void onAllConsumersRegistered() {
    }

    @Override
    protected boolean processRowsInternal(AnalysisListener listener, RowProcessingMetrics rowProcessingMetrics) {
        Collection<ActiveOutputDataStream> activeOutputDataStreams = this._parentConsumer.getActiveOutputDataStreams();
        for (ActiveOutputDataStream activeOutputDataStream : activeOutputDataStreams) {
            try {
                activeOutputDataStream.await();
            }
            catch (InterruptedException e) {
                logger.error("Unexpected error awaiting output data stream", (Throwable)e);
                listener.errorUnknown(this.getAnalysisJob(), e);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isReadyForRowProcessing() {
        return this._parentConsumer.isAllPublishersInitialized() && this._parentConsumer.isAllPublishersClosed();
    }

    @Override
    protected boolean runRowProcessingInternal(List<TaskRunnable> postProcessingTasks) {
        ForkTaskListener runCompletionListener = new ForkTaskListener("run row processing (" + this.getStream() + ")", this.getTaskRunner(), postProcessingTasks);
        RowProcessingMetrics rowProcessingMetrics = this.getRowProcessingMetrics();
        RunRowProcessingPublisherTask runTask = new RunRowProcessingPublisherTask(this, rowProcessingMetrics);
        this.getTaskRunner().run((Task)runTask, (TaskListener)runCompletionListener);
        return true;
    }

    @Override
    protected RowProcessingQueryOptimizer getQueryOptimizer() {
        Table table = this.getStream().getTable();
        Query q = new Query().from(table).select(table.getColumns());
        return new NoopRowProcessingQueryOptimizer(q, this.getConsumersSorted());
    }
}

