/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.datacleaner.api.ExpressionBasedInputColumn;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.MultiStreamComponent;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.HasFilterOutcomes;
import org.datacleaner.job.InputColumnSourceJob;
import org.datacleaner.job.runner.FilterOutcomesImpl;
import org.datacleaner.job.runner.RowProcessingConsumer;

class RowProcessingConsumerSorter {
    private final Collection<? extends RowProcessingConsumer> _consumers;

    public RowProcessingConsumerSorter(Collection<? extends RowProcessingConsumer> consumers) {
        this._consumers = consumers;
    }

    public List<RowProcessingConsumer> createProcessOrderedConsumerList() {
        ArrayList<RowProcessingConsumer> orderedConsumers = new ArrayList<RowProcessingConsumer>();
        LinkedList<? extends RowProcessingConsumer> remainingConsumers = new LinkedList<RowProcessingConsumer>(this._consumers);
        HashSet<Object> availableVirtualColumns = new HashSet<Object>();
        FilterOutcomesImpl availableOutcomes = new FilterOutcomesImpl();
        while (!remainingConsumers.isEmpty()) {
            RowProcessingConsumer consumer;
            boolean changed = false;
            Iterator it = remainingConsumers.iterator();
            while (it.hasNext()) {
                InputColumn<?>[] requiredInput;
                InputColumn<?>[] requiredInput2;
                consumer = (RowProcessingConsumer)it.next();
                boolean accepted = true;
                accepted = consumer.satisfiedForFlowOrdering(availableOutcomes);
                if (accepted && (requiredInput2 = consumer.getRequiredInput()) != null) {
                    for (InputColumn<?> inputColumn : requiredInput2) {
                        if (inputColumn.isPhysicalColumn() || inputColumn instanceof ExpressionBasedInputColumn || availableVirtualColumns.contains(inputColumn)) continue;
                        accepted = false;
                        break;
                    }
                }
                if (!accepted) continue;
                orderedConsumers.add(consumer);
                it.remove();
                changed = true;
                ComponentJob componentJob = consumer.getComponentJob();
                for (InputColumn<?> inputColumn : requiredInput = consumer.getRequiredInput()) {
                    if (!(inputColumn instanceof ExpressionBasedInputColumn)) continue;
                    availableVirtualColumns.add(inputColumn);
                }
                if (componentJob instanceof InputColumnSourceJob) {
                    InputColumn[] output;
                    for (InputColumn col : output = ((InputColumnSourceJob)componentJob).getOutput()) {
                        availableVirtualColumns.add(col);
                    }
                }
                if (!(componentJob instanceof HasFilterOutcomes)) continue;
                Collection outcomes = ((HasFilterOutcomes)componentJob).getFilterOutcomes();
                for (FilterOutcome outcome : outcomes) {
                    availableOutcomes.add(outcome);
                }
            }
            if (!changed) {
                it = remainingConsumers.iterator();
                while (it.hasNext()) {
                    consumer = (RowProcessingConsumer)it.next();
                    if (!(consumer.getComponent() instanceof MultiStreamComponent)) continue;
                    orderedConsumers.add(consumer);
                    it.remove();
                    changed = true;
                }
            }
            if (changed) continue;
            throw new IllegalStateException("Could not detect next consumer in processing order");
        }
        return orderedConsumers;
    }
}

