/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.LazyRef;
import org.apache.metamodel.util.Ref;
import org.datacleaner.components.convert.ConvertToNumberTransformer;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalyzerConsumer;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.runner.RowProcessingStream;

final class RowProcessingMetricsImpl
implements RowProcessingMetrics {
    private final RowProcessingPublishers _publishers;
    private final RowProcessingPublisher _publisher;
    private final Ref<Integer> _expectedRows;

    public RowProcessingMetricsImpl(RowProcessingPublishers publishers, RowProcessingPublisher publisher) {
        this._publishers = publishers;
        this._publisher = publisher;
        this._expectedRows = this.createExpectedRowsRef();
    }

    @Override
    public AnalysisJobMetrics getAnalysisJobMetrics() {
        return this._publishers.getAnalysisJobMetrics();
    }

    @Override
    public Query getQuery() {
        return this._publisher.getQuery();
    }

    @Override
    public RowProcessingStream getStream() {
        return this._publisher.getStream();
    }

    @Override
    public Table getTable() {
        return this._publisher.getStream().getTable();
    }

    @Override
    public int getExpectedRows() {
        Integer expectedRows = (Integer)this._expectedRows.get();
        return expectedRows;
    }

    @Override
    public ComponentJob[] getResultProducers() {
        ArrayList<ComponentJob> resultProducers = new ArrayList<ComponentJob>();
        for (RowProcessingConsumer consumer : this._publisher.getConsumers()) {
            if (!consumer.isResultProducer()) continue;
            resultProducers.add(consumer.getComponentJob());
        }
        return resultProducers.toArray(new ComponentJob[resultProducers.size()]);
    }

    @Override
    public AnalyzerJob[] getAnalyzerJobs() {
        ArrayList<AnalyzerJob> analyzerJobs = new ArrayList<AnalyzerJob>();
        for (RowProcessingConsumer consumer : this._publisher.getConsumers()) {
            if (!(consumer instanceof AnalyzerConsumer)) continue;
            AnalyzerJob analyzerJob = ((AnalyzerConsumer)consumer).getComponentJob();
            analyzerJobs.add(analyzerJob);
        }
        return analyzerJobs.toArray(new AnalyzerJob[analyzerJobs.size()]);
    }

    private Ref<Integer> createExpectedRowsRef() {
        return new LazyRef<Integer>(){

            protected Integer fetch() {
                int expectedRows = -1;
                Query originalQuery = RowProcessingMetricsImpl.this.getQuery();
                Query countQuery = originalQuery.clone();
                countQuery.setMaxRows(null);
                countQuery.setFirstRow(null);
                countQuery.getSelectClause().removeItems();
                countQuery.getOrderByClause().removeItems();
                countQuery.selectCount();
                ((SelectItem)countQuery.getSelectClause().getItem(0)).setFunctionApproximationAllowed(true);
                Datastore datastore = RowProcessingMetricsImpl.this._publisher.getStream().getAnalysisJob().getDatastore();
                try (DatastoreConnection connection = datastore.openConnection();
                     DataSet countDataSet = connection.getDataContext().executeQuery(countQuery);){
                    Number count;
                    if (countDataSet.next() && (count = ConvertToNumberTransformer.transformValue(countDataSet.getRow().getValue(0))) != null) {
                        expectedRows = count.intValue();
                    }
                }
                Integer maxRows = originalQuery.getMaxRows();
                if (maxRows != null) {
                    expectedRows = Math.min(expectedRows, maxRows);
                }
                return expectedRows;
            }
        };
    }
}

