/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.MetaModelHelper;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.datacleaner.api.Analyzer;
import org.datacleaner.api.Component;
import org.datacleaner.api.Filter;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.Transformer;
import org.datacleaner.configuration.ContextAwareInjectionManager;
import org.datacleaner.configuration.InjectionManager;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.AnalyzerJob;
import org.datacleaner.job.ComponentJob;
import org.datacleaner.job.ComponentRequirement;
import org.datacleaner.job.FilterJob;
import org.datacleaner.job.FilterOutcome;
import org.datacleaner.job.OutputDataStreamJob;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.concurrent.TaskRunner;
import org.datacleaner.job.runner.AnalysisJobMetrics;
import org.datacleaner.job.runner.AnalysisJobMetricsImpl;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.AnalyzerConsumer;
import org.datacleaner.job.runner.ErrorAware;
import org.datacleaner.job.runner.FilterConsumer;
import org.datacleaner.job.runner.OutputDataStreamRowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.runner.RowProcessingStream;
import org.datacleaner.job.runner.SourceTableRowProcessingPublisher;
import org.datacleaner.job.runner.TransformerConsumer;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.datacleaner.util.SourceColumnFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RowProcessingPublishers {
    private static final Logger logger = LoggerFactory.getLogger(RowProcessingPublishers.class);
    private final AnalysisJob _analysisJob;
    private final AnalysisListener _analysisListener;
    private final TaskRunner _taskRunner;
    private final LifeCycleHelper _lifeCycleHelper;
    private final Map<RowProcessingStream, RowProcessingPublisher> _rowProcessingPublishers;
    private final Map<ComponentJob, RowProcessingConsumer> _consumers;
    private final ErrorAware _errorAware;

    @Deprecated
    public RowProcessingPublishers(AnalysisJob analysisJob, AnalysisListener analysisListener, TaskRunner taskRunner, LifeCycleHelper lifeCycleHelper, SourceColumnFinder sourceColumnFinder) {
        this(analysisJob, analysisListener, (ErrorAware)((Object)analysisListener), taskRunner, lifeCycleHelper);
    }

    public RowProcessingPublishers(AnalysisJob analysisJob, AnalysisListener analysisListener, ErrorAware errorAware, TaskRunner taskRunner, LifeCycleHelper lifeCycleHelper) {
        this._analysisJob = analysisJob;
        this._analysisListener = analysisListener;
        this._errorAware = errorAware;
        this._taskRunner = taskRunner;
        this._lifeCycleHelper = lifeCycleHelper;
        this._rowProcessingPublishers = new LinkedHashMap<RowProcessingStream, RowProcessingPublisher>();
        this._consumers = new IdentityHashMap<ComponentJob, RowProcessingConsumer>();
        this.registerAll();
    }

    private void registerAll() {
        this.registerJob(this._analysisJob);
        Collection<RowProcessingPublisher> publishers = this._rowProcessingPublishers.values();
        for (RowProcessingPublisher publisher : publishers) {
            publisher.onAllConsumersRegistered();
        }
        if (logger.isInfoEnabled()) {
            logger.info("Registered {} publishers: {}", (Object)this._rowProcessingPublishers.size(), publishers);
        }
    }

    private void registerJob(AnalysisJob job) {
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(job);
        for (ComponentJob componentJob : RowProcessingPublishers.getAllComponents(job)) {
            this.registerRowProcessingPublishers(sourceColumnFinder, job, componentJob);
        }
    }

    private void registerJob(AnalysisJob job, RowProcessingStream dataStream, RowProcessingConsumer parentConsumer) {
        SourceColumnFinder sourceColumnFinder = new SourceColumnFinder();
        sourceColumnFinder.addSources(job);
        for (ComponentJob componentJob : RowProcessingPublishers.getAllComponents(job)) {
            this.registerRowProcessingPublishers(sourceColumnFinder, job, dataStream, componentJob, parentConsumer);
        }
    }

    public static Collection<ComponentJob> getAllComponents(AnalysisJob job) {
        return CollectionUtils.concat((boolean)false, (Collection)job.getFilterJobs(), (Collection[])new Collection[]{job.getTransformerJobs(), job.getAnalyzerJobs()});
    }

    private void registerOutputDataStream(RowProcessingPublisher parentPublisher, RowProcessingConsumer publishingConsumer, OutputDataStreamJob outputDataStreamJob) {
        RowProcessingStream dataStream = RowProcessingStream.ofOutputDataStream(outputDataStreamJob);
        this.registerJob(outputDataStreamJob.getJob(), dataStream, publishingConsumer);
        RowProcessingPublisher publisherForOutputDataStream = this.getRowProcessingPublisher(dataStream);
        publishingConsumer.registerOutputDataStream(outputDataStreamJob, publisherForOutputDataStream);
    }

    public Column[] getPhysicalColumns(SourceColumnFinder sourceColumnFinder, ComponentJob componentJob) {
        InputColumn[] inputColumns;
        HashSet<Column> physicalColumns = new HashSet<Column>();
        for (InputColumn inputColumn : inputColumns = componentJob.getInput()) {
            physicalColumns.addAll(sourceColumnFinder.findOriginatingColumns(inputColumn));
        }
        ComponentRequirement requirement = componentJob.getComponentRequirement();
        if (requirement != null) {
            for (FilterOutcome filterOutcome : requirement.getProcessingDependencies()) {
                physicalColumns.addAll(sourceColumnFinder.findOriginatingColumns(filterOutcome));
            }
        }
        Column[] physicalColumnsArray = physicalColumns.toArray(new Column[physicalColumns.size()]);
        return physicalColumnsArray;
    }

    public Table[] getTables(SourceColumnFinder sourceColumnFinder, ComponentJob componentJob) {
        return this.getTables(sourceColumnFinder, componentJob, null);
    }

    public Table[] getTables(SourceColumnFinder sourceColumnFinder, ComponentJob componentJob, Column[] physicalColumns) {
        Table[] tables;
        if (physicalColumns == null) {
            physicalColumns = this.getPhysicalColumns(sourceColumnFinder, componentJob);
        }
        if (physicalColumns.length == 0) {
            HashSet<Table> allTables = new HashSet<Table>();
            List allSourceColumns = this._analysisJob.getSourceColumns();
            for (InputColumn inputColumn : allSourceColumns) {
                allTables.add(inputColumn.getPhysicalColumn().getTable());
            }
            tables = allTables.toArray(new Table[allTables.size()]);
        } else {
            tables = MetaModelHelper.getTables((Column[])physicalColumns);
        }
        if (tables.length > 1 && !componentJob.getDescriptor().isMultiStreamComponent()) {
            throw new IllegalStateException("Component has input columns from multiple tables: " + componentJob);
        }
        if (tables.length == 0) {
            throw new IllegalStateException("Component has no dependent tables: " + componentJob);
        }
        return tables;
    }

    private void registerRowProcessingPublishers(SourceColumnFinder sourceColumnFinder, AnalysisJob job, ComponentJob componentJob) {
        Table[] tables;
        Column[] physicalColumns = this.getPhysicalColumns(sourceColumnFinder, componentJob);
        for (Table table : tables = this.getTables(sourceColumnFinder, componentJob, physicalColumns)) {
            RowProcessingStream dataStream = RowProcessingStream.ofSourceTable(job, table);
            this.registerRowProcessingPublishers(sourceColumnFinder, job, dataStream, componentJob, null);
        }
    }

    private void registerRowProcessingPublishers(SourceColumnFinder sourceColumnFinder, AnalysisJob job, RowProcessingStream dataStream, ComponentJob componentJob, RowProcessingConsumer parentConsumer) {
        SourceTableRowProcessingPublisher sourceTableRowPublisher;
        RowProcessingPublisher rowPublisher = this._rowProcessingPublishers.get(dataStream);
        if (rowPublisher == null) {
            if (parentConsumer == null) {
                sourceTableRowPublisher = new SourceTableRowProcessingPublisher(this, dataStream);
                sourceTableRowPublisher.addPrimaryKeysIfSourced();
                rowPublisher = sourceTableRowPublisher;
            } else {
                rowPublisher = new OutputDataStreamRowProcessingPublisher(this, parentConsumer, dataStream);
            }
            this._rowProcessingPublishers.put(dataStream, rowPublisher);
        }
        if (rowPublisher instanceof SourceTableRowProcessingPublisher) {
            sourceTableRowPublisher = (SourceTableRowProcessingPublisher)rowPublisher;
            Column[] physicalColumns = this.getPhysicalColumns(sourceColumnFinder, componentJob);
            Column[] relevantColumns = MetaModelHelper.getTableColumns((Table)dataStream.getTable(), (Column[])physicalColumns);
            sourceTableRowPublisher.addPhysicalColumns(relevantColumns);
        }
        InputColumn<?>[] localInputColumns = this.getLocalInputColumns(sourceColumnFinder, dataStream.getTable(), componentJob.getInput());
        ConsumerCreation consumerCreation = this.getOrCreateConsumer(rowPublisher, componentJob, localInputColumns);
        RowProcessingConsumer consumer = consumerCreation._consumer;
        rowPublisher.registerConsumer(consumer);
        if (consumerCreation._componentCreated) {
            OutputDataStreamJob[] outputDataStreamJobs;
            for (OutputDataStreamJob outputDataStreamJob : outputDataStreamJobs = componentJob.getOutputDataStreamJobs()) {
                this.registerOutputDataStream(rowPublisher, consumer, outputDataStreamJob);
            }
        }
    }

    public ConsumerCreation getOrCreateConsumer(RowProcessingPublisher publisher, ComponentJob componentJob, InputColumn<?>[] inputColumns) {
        boolean create;
        RowProcessingConsumer consumer = this._consumers.get(componentJob);
        boolean bl = create = consumer == null;
        if (create) {
            Component component = (Component)componentJob.getDescriptor().newInstance();
            if (componentJob instanceof AnalyzerJob) {
                AnalyzerJob analyzerJob = (AnalyzerJob)componentJob;
                Analyzer analyzer = (Analyzer)component;
                consumer = new AnalyzerConsumer(analyzer, analyzerJob, inputColumns, publisher);
            } else if (componentJob instanceof TransformerJob) {
                TransformerJob transformerJob = (TransformerJob)componentJob;
                Transformer transformer = (Transformer)component;
                consumer = new TransformerConsumer(transformer, transformerJob, inputColumns, publisher);
            } else if (componentJob instanceof FilterJob) {
                FilterJob filterJob = (FilterJob)componentJob;
                Filter filter = (Filter)component;
                consumer = new FilterConsumer(filter, filterJob, inputColumns, publisher);
            } else {
                throw new UnsupportedOperationException("Unsupported component job type: " + componentJob);
            }
            this._consumers.put(componentJob, consumer);
        }
        consumer.registerPublisher(publisher);
        return new ConsumerCreation(consumer, create);
    }

    private InputColumn<?>[] getLocalInputColumns(SourceColumnFinder sourceColumnFinder, Table table, InputColumn<?>[] inputColumns) {
        if (table == null || inputColumns == null || inputColumns.length == 0) {
            return new InputColumn[0];
        }
        ArrayList result = new ArrayList();
        block0: for (InputColumn<?> inputColumn : inputColumns) {
            Set<Column> sourcePhysicalColumns = sourceColumnFinder.findOriginatingColumns(inputColumn);
            for (Column physicalColumn : sourcePhysicalColumns) {
                if (!table.equals(physicalColumn.getTable())) continue;
                result.add(inputColumn);
                continue block0;
            }
        }
        return result.toArray(new InputColumn[result.size()]);
    }

    public int size() {
        return this._rowProcessingPublishers.size();
    }

    public RowProcessingPublisher getRowProcessingPublisher(RowProcessingStream stream) {
        return this._rowProcessingPublishers.get(stream);
    }

    public RowProcessingStream getStream(Table table) {
        Set<RowProcessingStream> dataStreams = this._rowProcessingPublishers.keySet();
        for (RowProcessingStream stream : dataStreams) {
            if (stream.getTable() != table) continue;
            return stream;
        }
        for (RowProcessingStream stream : dataStreams) {
            if (!table.equals(stream.getTable())) continue;
            return stream;
        }
        return null;
    }

    @Deprecated
    public RowProcessingPublisher getRowProcessingPublisher(Table table) {
        RowProcessingStream stream = this.getStream(table);
        return this.getRowProcessingPublisher(stream);
    }

    public Collection<RowProcessingPublisher> getRowProcessingPublishers() {
        return this._rowProcessingPublishers.values();
    }

    public RowProcessingStream[] getStreams() {
        Set<RowProcessingStream> streams = this._rowProcessingPublishers.keySet();
        return streams.toArray(new RowProcessingStream[streams.size()]);
    }

    @Deprecated
    public Table[] getTables() {
        RowProcessingStream[] streams = this.getStreams();
        Table[] tables = new Table[streams.length];
        for (int i = 0; i < tables.length; ++i) {
            tables[i] = streams[i].getTable();
        }
        return tables;
    }

    public AnalysisJobMetrics getAnalysisJobMetrics() {
        return new AnalysisJobMetricsImpl(this._analysisJob, this);
    }

    protected AnalysisListener getAnalysisListener() {
        return this._analysisListener;
    }

    protected LifeCycleHelper getLifeCycleHelper() {
        return this._lifeCycleHelper;
    }

    public TaskRunner getTaskRunner() {
        return this._taskRunner;
    }

    public LifeCycleHelper getConsumerSpecificLifeCycleHelper(RowProcessingConsumer consumer) {
        LifeCycleHelper outerLifeCycleHelper = this.getLifeCycleHelper();
        boolean includeNonDistributedTasks = outerLifeCycleHelper.isIncludeNonDistributedTasks();
        InjectionManager outerInjectionManager = outerLifeCycleHelper.getInjectionManager();
        ContextAwareInjectionManager injectionManager = new ContextAwareInjectionManager(outerInjectionManager, consumer.getAnalysisJob(), consumer.getComponentJob(), this.getAnalysisListener());
        LifeCycleHelper lifeCycleHelper = new LifeCycleHelper(injectionManager, includeNonDistributedTasks);
        return lifeCycleHelper;
    }

    public ErrorAware getErrorAware() {
        return this._errorAware;
    }

    private static class ConsumerCreation {
        final RowProcessingConsumer _consumer;
        final boolean _componentCreated;

        public ConsumerCreation(RowProcessingConsumer consumer, boolean componentCreated) {
            this._consumer = consumer;
            this._componentCreated = componentCreated;
        }
    }
}

