/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.Objects;
import org.apache.metamodel.schema.Table;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.OutputDataStreamJob;

public class RowProcessingStream {
    private final AnalysisJob _analysisJob;
    private final Table _table;
    private final boolean _sourceTable;

    public static RowProcessingStream ofOutputDataStream(OutputDataStreamJob outputDataStreamJob) {
        return new RowProcessingStream(outputDataStreamJob.getJob(), outputDataStreamJob.getOutputDataStream().getTable(), false);
    }

    public static RowProcessingStream ofSourceTable(AnalysisJob analysisJob, Table table) {
        return new RowProcessingStream(analysisJob, table, true);
    }

    private RowProcessingStream(AnalysisJob analysisJob, Table table, boolean sourceTable) {
        this._analysisJob = analysisJob;
        this._table = table;
        this._sourceTable = sourceTable;
    }

    public boolean isSourceTable() {
        return this._sourceTable;
    }

    public AnalysisJob getAnalysisJob() {
        return this._analysisJob;
    }

    public Table getTable() {
        return this._table;
    }

    public int hashCode() {
        return Objects.hash(this._analysisJob, this._table);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RowProcessingStream)) {
            return false;
        }
        RowProcessingStream other = (RowProcessingStream)obj;
        return Objects.equals(this._analysisJob, other._analysisJob) && Objects.equals(this._table, other._table);
    }

    public String toString() {
        return this.getTable().getName();
    }
}

