/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.jdbc.JdbcDataContext;
import org.apache.metamodel.query.Query;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.CollectionUtils;
import org.apache.metamodel.util.Func;
import org.apache.metamodel.util.LazyRef;
import org.datacleaner.api.InputColumn;
import org.datacleaner.connection.Datastore;
import org.datacleaner.connection.DatastoreConnection;
import org.datacleaner.data.MetaModelInputRow;
import org.datacleaner.job.concurrent.ForkTaskListener;
import org.datacleaner.job.concurrent.RunNextTaskTaskListener;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.concurrent.TaskRunnable;
import org.datacleaner.job.runner.AbstractRowProcessingPublisher;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.ConsumeRowHandler;
import org.datacleaner.job.runner.RowConsumerTaskListener;
import org.datacleaner.job.runner.RowProcessingMetrics;
import org.datacleaner.job.runner.RowProcessingPublishers;
import org.datacleaner.job.runner.RowProcessingQueryOptimizer;
import org.datacleaner.job.runner.RowProcessingQueryOptimizerImpl;
import org.datacleaner.job.runner.RowProcessingStream;
import org.datacleaner.job.runner.SimpleRowIdGenerator;
import org.datacleaner.job.tasks.ConsumeRowTask;
import org.datacleaner.job.tasks.RunRowProcessingPublisherTask;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.util.SystemProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SourceTableRowProcessingPublisher
extends AbstractRowProcessingPublisher {
    private static final Logger logger = LoggerFactory.getLogger(SourceTableRowProcessingPublisher.class);
    private final Set<Column> _physicalColumns = new LinkedHashSet<Column>();
    private final LazyRef<RowProcessingQueryOptimizer> _queryOptimizerRef = this.createQueryOptimizerRef();

    public SourceTableRowProcessingPublisher(RowProcessingPublishers publishers, RowProcessingStream stream) {
        super(publishers, stream);
        boolean aggressiveOptimizeSelectClause = SystemProperties.getBoolean("datacleaner.query.selectclause.optimize", false);
        if (!aggressiveOptimizeSelectClause) {
            List sourceColumns = stream.getAnalysisJob().getSourceColumns();
            ArrayList<Column> columns = new ArrayList<Column>();
            for (InputColumn sourceColumn : sourceColumns) {
                Column column = sourceColumn.getPhysicalColumn();
                if (column == null || !this.getTable().equals(column.getTable())) continue;
                columns.add(column);
            }
            this.addPhysicalColumns(columns.toArray(new Column[columns.size()]));
        }
    }

    private Table getTable() {
        return this.getStream().getTable();
    }

    public void addPrimaryKeysIfSourced() {
        Column[] primaryKeyColumns = this.getTable().getPrimaryKeys();
        if (primaryKeyColumns == null || primaryKeyColumns.length == 0) {
            logger.info("No primary keys defined for table {}, not pre-selecting primary keys", (Object)this.getTable().getName());
            return;
        }
        List sourceInputColumns = this.getAnalysisJob().getSourceColumns();
        List sourceColumns = CollectionUtils.map((Iterable)sourceInputColumns, (Func)new Func<InputColumn<?>, Column>(){

            public Column eval(InputColumn<?> inputColumn) {
                return inputColumn.getPhysicalColumn();
            }
        });
        for (Column primaryKeyColumn : primaryKeyColumns) {
            if (sourceColumns.contains(primaryKeyColumn)) continue;
            logger.info("Primary key column {} not added to source columns, not pre-selecting primary keys");
            return;
        }
        this.addPhysicalColumns(primaryKeyColumns);
    }

    private LazyRef<RowProcessingQueryOptimizer> createQueryOptimizerRef() {
        return new LazyRef<RowProcessingQueryOptimizer>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected RowProcessingQueryOptimizer fetch() {
                Datastore datastore = SourceTableRowProcessingPublisher.this.getAnalysisJob().getDatastore();
                try (DatastoreConnection con = datastore.openConnection();){
                    RowProcessingQueryOptimizerImpl optimizer;
                    DataContext dataContext = con.getDataContext();
                    Column[] columnArray = SourceTableRowProcessingPublisher.this._physicalColumns.toArray(new Column[SourceTableRowProcessingPublisher.this._physicalColumns.size()]);
                    Query baseQuery = dataContext.query().from(SourceTableRowProcessingPublisher.this.getTable()).select(columnArray).toQuery();
                    logger.debug("Base query for row processing: {}", (Object)baseQuery);
                    RowProcessingQueryOptimizerImpl rowProcessingQueryOptimizerImpl = optimizer = new RowProcessingQueryOptimizerImpl(datastore, SourceTableRowProcessingPublisher.this.getConsumersSorted(), baseQuery);
                    return rowProcessingQueryOptimizerImpl;
                }
                catch (RuntimeException e) {
                    logger.error("Failed to build query optimizer! {}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
            }
        };
    }

    @Override
    public void onAllConsumersRegistered() {
        this._queryOptimizerRef.requestLoad();
    }

    public void addPhysicalColumns(Column ... columns) {
        for (Column column : columns) {
            if (!this.getTable().equals(column.getTable())) {
                throw new IllegalArgumentException("Column does not pertain to the correct table. Expected table: " + this.getTable() + ", actual table: " + column.getTable());
            }
            this._physicalColumns.add(column);
        }
    }

    @Override
    protected RowProcessingQueryOptimizer getQueryOptimizer() {
        RowProcessingQueryOptimizer optimizer = (RowProcessingQueryOptimizer)this._queryOptimizerRef.get();
        if (optimizer == null) {
            Throwable e = this._queryOptimizerRef.getError();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException(e);
        }
        return optimizer;
    }

    @Override
    protected boolean processRowsInternal(AnalysisListener analysisListener, RowProcessingMetrics rowProcessingMetrics) {
        RowProcessingQueryOptimizer queryOptimizer = this.getQueryOptimizer();
        Query finalQuery = queryOptimizer.getOptimizedQuery();
        SimpleRowIdGenerator idGenerator = finalQuery.getFirstRow() == null ? new SimpleRowIdGenerator() : new SimpleRowIdGenerator(finalQuery.getFirstRow());
        analysisListener.rowProcessingBegin(this.getAnalysisJob(), rowProcessingMetrics);
        ConsumeRowHandler consumeRowHandler = this.createConsumeRowHandler();
        RowConsumerTaskListener taskListener = new RowConsumerTaskListener(this.getAnalysisJob(), analysisListener, this.getTaskRunner());
        Datastore datastore = this.getAnalysisJob().getDatastore();
        try (DatastoreConnection con = datastore.openConnection();){
            DataContext dataContext = con.getDataContext();
            if (logger.isDebugEnabled()) {
                String queryString;
                if (dataContext instanceof JdbcDataContext) {
                    JdbcDataContext jdbcDataContext = (JdbcDataContext)dataContext;
                    queryString = jdbcDataContext.getQueryRewriter().rewriteQuery(finalQuery);
                } else {
                    queryString = finalQuery.toSql();
                }
                logger.debug("Final query: {}", (Object)queryString);
                logger.debug("Final query firstRow={}, maxRows={}", (Object)finalQuery.getFirstRow(), (Object)finalQuery.getMaxRows());
            }
            int numTasks = 0;
            try (DataSet dataSet = dataContext.executeQuery(finalQuery);){
                while (dataSet.next()) {
                    if (taskListener.isErrornous()) {
                        break;
                    }
                    Row metaModelRow = dataSet.getRow();
                    int rowId = idGenerator.nextPhysicalRowId();
                    MetaModelInputRow inputRow = new MetaModelInputRow(rowId, metaModelRow);
                    ConsumeRowTask task = new ConsumeRowTask(consumeRowHandler, rowProcessingMetrics, inputRow, analysisListener, ++numTasks);
                    this.getTaskRunner().run((Task)task, (TaskListener)taskListener);
                }
            }
            taskListener.awaitTasks(numTasks);
        }
        return !taskListener.isErrornous();
    }

    @Override
    protected boolean runRowProcessingInternal(List<TaskRunnable> postProcessingTasks) {
        ForkTaskListener runCompletionListener = new ForkTaskListener("run row processing (" + this.getStream() + ")", this.getTaskRunner(), postProcessingTasks);
        RowProcessingMetrics rowProcessingMetrics = this.getRowProcessingMetrics();
        RunRowProcessingPublisherTask runTask = new RunRowProcessingPublisherTask(this, rowProcessingMetrics);
        RunNextTaskTaskListener initFinishedListener = new RunNextTaskTaskListener(this.getTaskRunner(), runTask, runCompletionListener);
        this.initializeConsumers(initFinishedListener);
        return true;
    }
}

