/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.runner;

import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.datacleaner.api.Concurrent;
import org.datacleaner.api.InputColumn;
import org.datacleaner.api.InputRow;
import org.datacleaner.api.OutputRowCollector;
import org.datacleaner.api.Transformer;
import org.datacleaner.data.TransformedInputRow;
import org.datacleaner.descriptors.ProvidedPropertyDescriptor;
import org.datacleaner.job.FilterOutcomes;
import org.datacleaner.job.HasComponentRequirement;
import org.datacleaner.job.InputColumnSinkJob;
import org.datacleaner.job.TransformerJob;
import org.datacleaner.job.concurrent.ThreadLocalOutputRowCollector;
import org.datacleaner.job.runner.AbstractRowProcessingConsumer;
import org.datacleaner.job.runner.RowIdGenerator;
import org.datacleaner.job.runner.RowProcessingChain;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingPublisher;

final class TransformerConsumer
extends AbstractRowProcessingConsumer
implements RowProcessingConsumer {
    private final Transformer _transformer;
    private final TransformerJob _transformerJob;
    private final InputColumn<?>[] _inputColumns;
    private final boolean _concurrent;
    private final Set<ProvidedPropertyDescriptor> _outputRowCollectorProperties;
    private RowIdGenerator _idGenerator;

    public TransformerConsumer(Transformer transformer, TransformerJob transformerJob, InputColumn<?>[] inputColumns, RowProcessingPublisher publisher) {
        super(publisher, (HasComponentRequirement)transformerJob, (InputColumnSinkJob)transformerJob);
        this._transformer = transformer;
        this._transformerJob = transformerJob;
        this._inputColumns = inputColumns;
        this._concurrent = this.determineConcurrent();
        this._outputRowCollectorProperties = this._transformerJob.getDescriptor().getProvidedPropertiesByType(OutputRowCollector.class);
    }

    private boolean determineConcurrent() {
        Concurrent concurrent = (Concurrent)this._transformerJob.getDescriptor().getAnnotation(Concurrent.class);
        if (concurrent == null) {
            return true;
        }
        return concurrent.value();
    }

    public void setRowIdGenerator(RowIdGenerator idGenerator) {
        this._idGenerator = idGenerator;
    }

    @Override
    public boolean isConcurrent() {
        return this._concurrent;
    }

    @Override
    public InputColumn<?>[] getRequiredInput() {
        return this._inputColumns;
    }

    public Transformer getComponent() {
        return this._transformer;
    }

    @Override
    public InputColumn<?>[] getOutputColumns() {
        return this._transformerJob.getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void consumeInternal(InputRow row, int distinctCount, FilterOutcomes outcomes, RowProcessingChain chain) {
        InputColumn<?>[] outputColumns = this.getOutputColumns();
        this.registerListener(this._transformer, row, outcomes, chain, outputColumns);
        try {
            Object[] values = this._transformer.transform(row);
            if (values == null) {
                return;
            }
            TransformedInputRow resultRow = TransformedInputRow.of(row);
            this.addValuesToRow(resultRow, outputColumns, values);
            chain.processNext(resultRow, distinctCount, outcomes);
        }
        finally {
            this.unregisterListener(this._transformer);
        }
    }

    private void unregisterListener(Transformer transformer) {
        for (ProvidedPropertyDescriptor descriptor : this._outputRowCollectorProperties) {
            OutputRowCollector outputRowCollector = (OutputRowCollector)descriptor.getValue((Object)transformer);
            if (!(outputRowCollector instanceof ThreadLocalOutputRowCollector)) continue;
            ((ThreadLocalOutputRowCollector)outputRowCollector).removeListener();
        }
    }

    private void registerListener(Transformer transformer, final InputRow row, final FilterOutcomes outcomes, final RowProcessingChain chain, final InputColumn<?>[] outputColumns) {
        if (this._outputRowCollectorProperties.isEmpty()) {
            return;
        }
        ThreadLocalOutputRowCollector.Listener listener = new ThreadLocalOutputRowCollector.Listener(){
            private AtomicInteger recordNumber = new AtomicInteger(0);

            @Override
            public void onValues(Object[] values) {
                int recordNo = this.recordNumber.incrementAndGet();
                boolean isFirst = recordNo == 1;
                TransformedInputRow resultRow = isFirst ? TransformedInputRow.of(row) : new TransformedInputRow(row, TransformerConsumer.this.getNextVirtualRowId(row, recordNo));
                TransformerConsumer.this.addValuesToRow(resultRow, outputColumns, values);
                FilterOutcomes clonedOutcomeSink = outcomes.clone();
                chain.processNext(resultRow, 1, clonedOutcomeSink);
            }
        };
        for (ProvidedPropertyDescriptor descriptor : this._outputRowCollectorProperties) {
            OutputRowCollector outputRowCollector = (OutputRowCollector)descriptor.getValue((Object)transformer);
            if (outputRowCollector instanceof ThreadLocalOutputRowCollector) {
                ((ThreadLocalOutputRowCollector)outputRowCollector).setListener(listener);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported output row collector type: " + outputRowCollector);
        }
    }

    private long getNextVirtualRowId(InputRow row, int recordNo) {
        if (this._idGenerator == null) {
            long offset = Long.MAX_VALUE;
            long hiLoIntervalOffset = row.getId() * 10000L;
            return offset - hiLoIntervalOffset + (long)recordNo;
        }
        return this._idGenerator.nextVirtualRowId();
    }

    private void addValuesToRow(TransformedInputRow resultRow, InputColumn<?>[] outputColumns, Object[] values) {
        assert (outputColumns.length == values.length);
        for (int i = 0; i < outputColumns.length; ++i) {
            Object value = i < values.length ? values[i] : null;
            InputColumn<?> column = outputColumns[i];
            resultRow.addValue(column, value);
        }
    }

    public TransformerJob getComponentJob() {
        return this._transformerJob;
    }

    public String toString() {
        return "TransformerConsumer[" + this._transformer + "]";
    }
}

