/*
 * Decompiled with CFR 0.152.
 */
package org.datacleaner.job.tasks;

import java.util.concurrent.atomic.AtomicBoolean;
import org.datacleaner.descriptors.ComponentDescriptor;
import org.datacleaner.job.AnalysisJob;
import org.datacleaner.job.concurrent.TaskListener;
import org.datacleaner.job.runner.ActiveOutputDataStream;
import org.datacleaner.job.runner.AnalysisListener;
import org.datacleaner.job.runner.RowProcessingConsumer;
import org.datacleaner.job.runner.RowProcessingPublisher;
import org.datacleaner.job.tasks.Task;
import org.datacleaner.lifecycle.LifeCycleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseTaskListener
implements TaskListener {
    private static final Logger logger = LoggerFactory.getLogger(CloseTaskListener.class);
    private final AtomicBoolean _success;
    private final LifeCycleHelper _lifeCycleHelper;
    private final RowProcessingPublisher _publisher;
    private final RowProcessingConsumer _consumer;
    private final TaskListener _nextTaskListener;
    private final AnalysisListener _analysisListener;
    private final AnalysisJob _analysisJob;

    public CloseTaskListener(LifeCycleHelper lifeCycleHelper, RowProcessingPublisher publisher, RowProcessingConsumer consumer, AtomicBoolean success, TaskListener nextTaskListener, AnalysisListener analysisListener, AnalysisJob analysisJob) {
        this._lifeCycleHelper = lifeCycleHelper;
        this._publisher = publisher;
        this._consumer = consumer;
        this._success = success;
        this._nextTaskListener = nextTaskListener;
        this._analysisListener = analysisListener;
        this._analysisJob = analysisJob;
    }

    private void cleanup() {
        logger.debug("cleanup()");
        int publishersLeft = this._consumer.onPublisherClosed(this._publisher);
        if (publishersLeft == 0) {
            Object component = this._consumer.getComponent();
            ComponentDescriptor descriptor = this._consumer.getComponentJob().getDescriptor();
            this._lifeCycleHelper.close(descriptor, component, this._success.get());
            this._consumer.getActiveOutputDataStreams().forEach(ActiveOutputDataStream::close);
        }
    }

    public void onBegin(Task task) {
        if (this._nextTaskListener != null) {
            this._nextTaskListener.onBegin(task);
        }
    }

    public void onComplete(Task task) {
        try {
            this.cleanup();
        }
        catch (Exception e) {
            this.onErrorInternal(task, e, false);
            return;
        }
        if (this._nextTaskListener != null) {
            this._nextTaskListener.onComplete(task);
        }
    }

    public void onError(Task task, Throwable throwable) {
        this.onErrorInternal(task, throwable, true);
    }

    private void onErrorInternal(Task task, Throwable throwable, boolean doCleanup) {
        boolean previouslySuccessful = this._success.getAndSet(false);
        if (doCleanup) {
            try {
                this.cleanup();
            }
            catch (Exception e) {
                throwable.addSuppressed(e);
            }
        }
        if (previouslySuccessful) {
            this._analysisListener.errorUnknown(this._analysisJob, throwable);
        }
        if (this._nextTaskListener != null) {
            this._nextTaskListener.onError(task, throwable);
        }
    }
}

